/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.jmx;

import com.google.cloud.Timestamp;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.context.source.SpannerSourceTaskContext;
import io.debezium.connector.spanner.metrics.SpannerMeter;
import io.debezium.connector.spanner.metrics.jmx.JsonSerializer;
import io.debezium.connector.spanner.metrics.jmx.SpannerMetricsMXBean;
import io.debezium.data.Envelope;
import io.debezium.pipeline.metrics.CapturedTablesSupplier;
import io.debezium.pipeline.metrics.DefaultStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import org.apache.kafka.connect.data.Struct;

public class SpannerStreamingChangeEventSourceMetrics
extends DefaultStreamingChangeEventSourceMetrics<SpannerPartition>
implements SpannerMetricsMXBean {
    private static final String TASK_ID_TAG = "Task";
    private static final String CONNECTOR_NAME_TAG = "ConnectorName";
    private static final String NOT_YET_CALCULATED = "not yet calculated";
    private final SpannerMeter spannerMeter;
    private final JsonSerializer jsonSerializer;

    public SpannerStreamingChangeEventSourceMetrics(SpannerSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, SpannerMeter spannerMeter, CapturedTablesSupplier capturedTablesSupplier) {
        super((CdcSourceTaskContext)taskContext, changeEventQueueMetrics, metadataProvider, Collect.linkMapOf((Object)CONNECTOR_NAME_TAG, (Object)taskContext.getConnectorLogicalName(), (Object)TASK_ID_TAG, (Object)("Task-" + taskContext.getTaskId())), capturedTablesSupplier);
        this.spannerMeter = spannerMeter;
        this.jsonSerializer = new JsonSerializer();
    }

    public void onEvent(SpannerPartition partition, DataCollectionId source, OffsetContext offset, Object key, Struct value, Envelope.Operation operation) {
        super.onEvent((Partition)partition, source, offset, key, value, operation);
        this.spannerMeter.captureTable(source);
    }

    public void reset() {
        super.reset();
        this.spannerMeter.reset();
    }

    @Override
    public String getLowWatermark() throws InterruptedException {
        Timestamp timestamp = this.spannerMeter.getLowWatermark();
        return timestamp != null ? timestamp.toString() : NOT_YET_CALCULATED;
    }

    @Override
    public Long getMilliSecondsLowWatermark() throws InterruptedException {
        Timestamp timestamp = this.spannerMeter.getLowWatermark();
        return timestamp != null ? Long.valueOf(timestamp.toSqlTimestamp().toInstant().toEpochMilli()) : null;
    }

    @Override
    public Long getMilliSecondsLowWatermarkLag() throws InterruptedException {
        return this.spannerMeter.getLowWatermarkLag();
    }

    @Override
    public int getNumberOfChangeStreamPartitionsDetected() {
        return this.spannerMeter.getNumberOfPartitionsDetected();
    }

    @Override
    public int getNumberOfChangeStreamQueriesIssuedTotal() {
        return this.spannerMeter.getNumberOfQueriesIssuedTotal();
    }

    @Override
    public int getNumberOfActiveChangeStreamQueries() {
        return this.spannerMeter.getNumberOfActiveQueries();
    }

    @Override
    public int getStuckHeartbeatIntervals() {
        return this.spannerMeter.getStuckHeartbeatIntervals();
    }

    @Override
    public Long getDelayChangeStreamEventsLastMilliSeconds() {
        return this.spannerMeter.getDelayChangeStreamEvents().getLastValue();
    }

    @Override
    public Double getDelayChangeStreamEventsP50MilliSeconds() {
        return this.spannerMeter.getDelayChangeStreamEvents().getValueAtP50();
    }

    @Override
    public Double getDelayChangeStreamEventsP95MilliSeconds() {
        return this.spannerMeter.getDelayChangeStreamEvents().getValueAtP95();
    }

    @Override
    public Double getDelayChangeStreamEventsP99MilliSeconds() {
        return this.spannerMeter.getDelayChangeStreamEvents().getValueAtP99();
    }

    @Override
    public int getErrorCount() {
        return this.spannerMeter.getErrorCount();
    }

    @Override
    public String getTaskSyncContext() {
        return this.jsonSerializer.writeValueAsString(this.spannerMeter.getTaskSyncContext());
    }

    @Override
    public String getTaskUid() {
        return this.spannerMeter.getTaskUid();
    }

    @Override
    public Long getLatencyLowWatermarkLagMinMilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getMinValue();
    }

    @Override
    public Long getLatencyLowWatermarkLagMaxMilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getMaxValue();
    }

    @Override
    public Double getLatencyLowWatermarkLagAvgMilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getAverageValue();
    }

    @Override
    public Double getLatencyLowWatermarkLagP50MilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyLowWatermarkLagP95MilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyLowWatermarkLagP99MilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyTotalMinMilliSeconds() {
        return this.spannerMeter.getTotalLatency().getMinValue();
    }

    @Override
    public Long getLatencyTotalMaxMilliSeconds() {
        return this.spannerMeter.getTotalLatency().getMaxValue();
    }

    @Override
    public Double getLatencyTotalAvgMilliSeconds() {
        return this.spannerMeter.getTotalLatency().getAverageValue();
    }

    @Override
    public Double getLatencyTotalP50MilliSeconds() {
        return this.spannerMeter.getTotalLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyTotalP95MilliSeconds() {
        return this.spannerMeter.getTotalLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyTotalP99MilliSeconds() {
        return this.spannerMeter.getTotalLatency().getValueAtP99();
    }

    @Override
    public Long getLatencySpannerMinMilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getMinValue();
    }

    @Override
    public Long getLatencySpannerMaxMilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getMaxValue();
    }

    @Override
    public Double getLatencySpannerAvgMilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getAverageValue();
    }

    @Override
    public Double getLatencySpannerP50MilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getValueAtP50();
    }

    @Override
    public Double getLatencySpannerP95MilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getValueAtP95();
    }

    @Override
    public Double getLatencySpannerP99MilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyReadToEmitMinMilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getMinValue();
    }

    @Override
    public Long getLatencyReadToEmitMaxMilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getMaxValue();
    }

    @Override
    public Double getLatencyReadToEmitAvgMilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getAverageValue();
    }

    @Override
    public Double getLatencyReadToEmitP50MilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyReadToEmitP95MilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyReadToEmitP99MilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyCommitToEmitMinMilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getMinValue();
    }

    @Override
    public Long getLatencyCommitToEmitMaxMilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getMaxValue();
    }

    @Override
    public Double getLatencyCommitToEmitAvgMilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getAverageValue();
    }

    @Override
    public Double getLatencyCommitToEmitP50MilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyCommitToEmitP95MilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyCommitToEmitP99MilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyCommitToPublishMinMilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getMinValue();
    }

    @Override
    public Long getLatencyCommitToPublishMaxMilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getMaxValue();
    }

    @Override
    public Double getLatencyCommitToPublishAvgMilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getAverageValue();
    }

    @Override
    public Double getLatencyCommitToPublishP50MilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyCommitToPublishP95MilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyCommitToPublishP99MilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyEmitToPublishMinMilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getMinValue();
    }

    @Override
    public Long getLatencyEmitToPublishMaxMilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getMaxValue();
    }

    @Override
    public Double getLatencyEmitToPublishAvgMilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getAverageValue();
    }

    @Override
    public Double getLatencyEmitToPublishP50MilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyEmitToPublishP95MilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyEmitToPublishP99MilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getValueAtP99();
    }

    @Override
    public Long getDebugLatencyOwnConnectorMinMilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getMinValue();
    }

    @Override
    public Long getDebugLatencyOwnConnectorMaxMilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getMaxValue();
    }

    @Override
    public Double getDebugLatencyOwnConnectorAvgMilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getAverageValue();
    }

    @Override
    public Long getDebugLatencyOwnConnectorLastMilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getLastValue();
    }

    @Override
    public Double getDebugLatencyOwnConnectorP50MilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getValueAtP50();
    }

    @Override
    public Double getDebugLatencyOwnConnectorP95MilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getValueAtP95();
    }

    @Override
    public Double getDebugLatencyOwnConnectorP99MilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getValueAtP99();
    }

    @Override
    public Long getPartitionOffsetLagMinMilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getMinValue();
    }

    @Override
    public Long getPartitionOffsetLagMaxMilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getMaxValue();
    }

    @Override
    public Double getPartitionOffsetLagAvgMilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getAverageValue();
    }

    @Override
    public Double getPartitionOffsetLagP50MilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getValueAtP50();
    }

    @Override
    public Double getPartitionOffsetLagP95MilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getValueAtP95();
    }

    @Override
    public Double getPartitionOffsetLagP99MilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getValueAtP99();
    }

    @Override
    public Long getPartitionOffsetLagLastMilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getLastValue();
    }

    @Override
    public Long getOffsetReceivingTimeMinMilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getMinValue();
    }

    @Override
    public Long getOffsetReceivingTimeMaxMilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getMaxValue();
    }

    @Override
    public Double getOffsetReceivingTimeAvgMilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getAverageValue();
    }

    @Override
    public Double getOffsetReceivingTimeP50MilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getValueAtP50();
    }

    @Override
    public Double getOffsetReceivingTimeP95MilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getValueAtP95();
    }

    @Override
    public Double getOffsetReceivingTimeP99MilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getValueAtP99();
    }

    @Override
    public Long getOffsetReceivingTimeLastMilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getLastValue();
    }

    @Override
    public int getSpannerEventQueueTotalCapacity() {
        return this.spannerMeter.getSpannerEventQueueTotalCapacity();
    }

    @Override
    public int getTaskStateChangeEventQueueRemainingCapacity() {
        return this.spannerMeter.getTaskStateChangeEventQueueRemainingCapacity();
    }

    @Override
    public int getSpannerEventQueueRemainingCapacity() {
        return this.spannerMeter.getSpannerEventQueueRemainingCapacity();
    }

    @Override
    public boolean isLeader() {
        return this.spannerMeter.isLeader();
    }

    @Override
    public long getRebalanceGenerationId() {
        return this.spannerMeter.getRebalanceGenerationId();
    }

    @Override
    public int getRebalanceAnswersActual() {
        return this.spannerMeter.getRebalanceAnswersActual();
    }

    @Override
    public int getRebalanceAnswersExpected() {
        return this.spannerMeter.getRebalanceAnswersExpected();
    }

    @Override
    public void finishTask() {
        this.spannerMeter.finishTask();
    }

    @Override
    public void restartTask() {
        this.spannerMeter.restartTask();
    }
}

