/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Struct;
import com.google.protobuf.AbstractMessage;
import com.google.spanner.v1.ChangeStreamRecord;
import io.debezium.connector.spanner.db.dao.ChangeStreamResultSetMetadata;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class ChangeStreamResultSet
implements AutoCloseable {
    private final ResultSet resultSet;
    private Timestamp queryStartedAt;
    private Timestamp recordStreamStartedAt;
    private Timestamp recordStreamEndedAt;
    private Timestamp recordReadAt;
    private Duration totalStreamDuration;
    private long numberOfRecordsRead;

    ChangeStreamResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        this.queryStartedAt = Timestamp.MIN_VALUE;
        this.recordStreamStartedAt = Timestamp.MIN_VALUE;
        this.recordStreamEndedAt = Timestamp.MIN_VALUE;
        this.recordReadAt = Timestamp.MIN_VALUE;
        this.totalStreamDuration = Duration.ZERO;
        this.numberOfRecordsRead = 0L;
    }

    public boolean next() {
        if (this.queryStartedAt == null) {
            this.queryStartedAt = Timestamp.now();
        }
        this.recordStreamStartedAt = Timestamp.now();
        boolean hasNext = this.resultSet.next();
        ++this.numberOfRecordsRead;
        this.recordStreamEndedAt = Timestamp.now();
        this.totalStreamDuration = this.totalStreamDuration.withDurationAdded((ReadableDuration)new Duration(this.recordStreamStartedAt.toSqlTimestamp().getTime(), this.recordStreamEndedAt.toSqlTimestamp().getTime()), 1);
        return hasNext;
    }

    public Struct getCurrentRowAsStruct() {
        this.recordReadAt = Timestamp.now();
        return this.resultSet.getCurrentRowAsStruct();
    }

    public ChangeStreamResultSetMetadata getMetadata() {
        return new ChangeStreamResultSetMetadata(this.queryStartedAt, this.recordStreamStartedAt, this.recordStreamEndedAt, this.recordReadAt, this.totalStreamDuration, this.numberOfRecordsRead);
    }

    @Override
    public void close() {
        this.resultSet.close();
    }

    public String getPgJsonb(int index) {
        this.recordReadAt = Timestamp.now();
        return this.resultSet.getPgJsonb(index);
    }

    public ChangeStreamRecord getProtoChangeStreamRecord(int index) {
        this.recordReadAt = Timestamp.now();
        return (ChangeStreamRecord)this.resultSet.getProtoMessage(index, (AbstractMessage)ChangeStreamRecord.getDefaultInstance());
    }
}

