/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db;

import com.google.cloud.spanner.Options;
import io.debezium.connector.spanner.db.DatabaseClientFactory;
import io.debezium.connector.spanner.db.dao.ChangeStreamDao;
import io.debezium.connector.spanner.db.dao.SchemaDao;

public class DaoFactory {
    private final DatabaseClientFactory databaseClientFactory;
    private SchemaDao schemaDao;

    public DaoFactory(DatabaseClientFactory databaseClientFactory) {
        this.databaseClientFactory = databaseClientFactory;
    }

    public SchemaDao getSchemaDao() {
        if (this.schemaDao != null) {
            return this.schemaDao;
        }
        this.schemaDao = new SchemaDao(this.databaseClientFactory.getDatabaseClient());
        return this.schemaDao;
    }

    public ChangeStreamDao getStreamDao(String changeStreamName, Options.RpcPriority rpcPriority, String jobName) {
        SchemaDao schemaDao = this.getSchemaDao();
        boolean isMutableKeyRange = schemaDao.isMutableKeyRangeChangeStream(changeStreamName);
        return new ChangeStreamDao(changeStreamName, isMutableKeyRange, this.databaseClientFactory.getDatabaseClient(), rpcPriority, jobName);
    }
}

