/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.scaler;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.scaler.TaskScaleCalculator;
import io.debezium.connector.spanner.task.scaler.TaskScalerUtil;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskScaler {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskScaler.class);
    private final SpannerConnectorConfig connectorConfig;
    private final ConnectorContext connectorContext;

    public TaskScaler(SpannerConnectorConfig connectorConfig, ConnectorContext connectorContext) {
        this.connectorConfig = connectorConfig;
        this.connectorContext = connectorContext;
    }

    public int ensureTasksScale(TaskSyncEvent taskSyncEvent) {
        int actualTasksCount = TaskScalerUtil.tasksCount(taskSyncEvent);
        return this.ensureTasksScale(taskSyncEvent, actualTasksCount);
    }

    public int ensureTasksScale(TaskSyncEvent taskSyncEvent, int actualTasksCount) {
        int requiredTasksCount = this.getTasksCount(taskSyncEvent, actualTasksCount);
        long epochOffset = taskSyncEvent.getEpochOffset();
        if (requiredTasksCount == actualTasksCount) {
            LOGGER.info("ensureTasksScale: no scaling is required, tasks count: {}, epochOffset: {}", (Object)actualTasksCount, (Object)epochOffset);
            return actualTasksCount;
        }
        if (requiredTasksCount > actualTasksCount) {
            LOGGER.info("ensureTasksScale: needs to scale out, tasks count: actual = {}, required = {}, epochOffset: {}", new Object[]{actualTasksCount, requiredTasksCount, epochOffset});
        } else {
            LOGGER.info("ensureTasksScale: needs to scale in, tasks count: actual = {}, required = {}, epochOffset: {}", new Object[]{actualTasksCount, requiredTasksCount, epochOffset});
        }
        this.connectorContext.requestTaskReconfiguration();
        return requiredTasksCount;
    }

    public int getTasksCount(TaskSyncEvent taskSyncEvent, int currentTasksCount) {
        int desiredPartitionsTasks = this.connectorConfig.getDesiredPartitionsTasks();
        int maxTasks = this.connectorConfig.getMaxTasks();
        int minTasks = this.connectorConfig.getMinTasks();
        long partitionsInWorkCount = TaskScalerUtil.partitionsInWorkCount(taskSyncEvent);
        long idlingTaskCount = TaskScalerUtil.idlingTaskCount(taskSyncEvent);
        LOGGER.info("getTasksCount: currentTasksCount = {}, desiredPartitionsTasks = {}, maxTasks = {}, minTasks = {}, partitionsInWorkCount = {}, idlingTaskCount = {}", new Object[]{currentTasksCount, desiredPartitionsTasks, maxTasks, minTasks, partitionsInWorkCount, idlingTaskCount});
        return TaskScaleCalculator.newTasksCount(currentTasksCount, desiredPartitionsTasks, maxTasks, minTasks, partitionsInWorkCount, idlingTaskCount);
    }
}

