/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.pipeline.spi.Partition;
import io.debezium.util.Collect;
import java.util.Map;
import java.util.Objects;

public class SpannerPartition
implements Partition {
    private static final String PARTITION_TOKEN_KEY = "partitionToken";
    private final String partitionToken;

    public SpannerPartition(String partitionToken) {
        this.partitionToken = partitionToken;
    }

    public Map<String, String> getSourcePartition() {
        return Collect.hashMapOf((Object)PARTITION_TOKEN_KEY, (Object)this.partitionToken);
    }

    public String toString() {
        return "SpannerPartition[" + String.valueOf(this.getSourcePartition()) + "]";
    }

    public String getValue() {
        return this.partitionToken;
    }

    public static String extractToken(Map<String, ?> sourcePartition) {
        return (String)sourcePartition.get(PARTITION_TOKEN_KEY);
    }

    public static SpannerPartition getInitialSpannerPartition() {
        return new SpannerPartition("Parent0");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpannerPartition that = (SpannerPartition)o;
        return Objects.equals(this.partitionToken, that.partitionToken);
    }

    public int hashCode() {
        return Objects.hash(this.partitionToken);
    }
}

