/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.schema.mapper;

import com.fasterxml.jackson.databind.JsonNode;
import io.debezium.connector.spanner.schema.mapper.JsonNodeStructValueConvertor;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;

public class FieldJsonNodeValueMapper {
    private FieldJsonNodeValueMapper() {
    }

    public static Object getValue(Field field, JsonNode node) {
        Schema.Type type = field.schema().type();
        switch (type) {
            case FLOAT32: {
                return JsonNodeStructValueConvertor.getFloat(node);
            }
            case FLOAT64: {
                return JsonNodeStructValueConvertor.getDouble(node);
            }
            case STRING: {
                return JsonNodeStructValueConvertor.getString(node);
            }
            case INT64: {
                return JsonNodeStructValueConvertor.getLong(node);
            }
            case BOOLEAN: {
                return JsonNodeStructValueConvertor.getBoolean(node);
            }
            case BYTES: {
                return JsonNodeStructValueConvertor.getBytes(node);
            }
            case ARRAY: {
                return JsonNodeStructValueConvertor.getList(node, field.schema().valueSchema().type());
            }
        }
        throw new IllegalArgumentException("unsupported field type: " + String.valueOf(type));
    }
}

