/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.processor.metadata;

import io.debezium.connector.spanner.processor.metadata.EventFormatter;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Instant;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;

public class SpannerEventMetadataProvider
implements EventMetadataProvider {
    public Instant getEventTimestamp(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        Long timestamp = sourceInfo.getInt64("ts_ms");
        return timestamp == null ? null : Instant.ofEpochMilli(timestamp);
    }

    public Map<String, String> getEventSourcePosition(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        String streamName = sourceInfo.getString("change_stream_name");
        String tableName = sourceInfo.getString("table");
        return Collect.hashMapOf((Object)"sequence", (Object)sourceInfo.getString("sequence"), (Object)"change_stream_name", (Object)streamName, (Object)"table", (Object)tableName);
    }

    public String getTransactionId(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        if (value == null) {
            return null;
        }
        Struct sourceInfo = value.getStruct("source");
        if (source == null) {
            return null;
        }
        return sourceInfo.getString("server_transaction_id");
    }

    public String toSummaryString(DataCollectionId source, OffsetContext offset, Object key, Struct value) {
        return new EventFormatter().sourcePosition(this.getEventSourcePosition(source, offset, key, value)).key(key).value(value).toString();
    }
}

