/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.latency;

import io.debezium.connector.spanner.metrics.latency.QuantileMeter;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class Metric {
    private final AtomicReference<Duration> minimum = new AtomicReference<Duration>(Duration.ofSeconds(Long.MAX_VALUE));
    private final AtomicReference<Duration> maximum = new AtomicReference<Duration>(Duration.ZERO);
    private final AtomicReference<Duration> last = new AtomicReference<Duration>(Duration.ZERO);
    private final AtomicReference<Duration> total = new AtomicReference<Duration>(Duration.ZERO);
    private final AtomicReference<Duration> average = new AtomicReference<Duration>(Duration.ZERO);
    private final QuantileMeter quantileMeter;
    private final AtomicLong count = new AtomicLong();

    public Metric(Duration percentageMetricsClearInterval, Consumer<Throwable> errorConsumer) {
        this.quantileMeter = new QuantileMeter(percentageMetricsClearInterval, errorConsumer);
    }

    public void reset() {
        this.minimum.set(Duration.ofSeconds(Long.MAX_VALUE));
        this.maximum.set(Duration.ZERO);
        this.last.set(Duration.ZERO);
        this.total.set(Duration.ZERO);
        this.average.set(Duration.ZERO);
        this.quantileMeter.reset();
        this.count.set(0L);
    }

    public void start() {
        this.quantileMeter.start();
    }

    public void shutdown() {
        this.quantileMeter.shutdown();
    }

    void set(Duration lastDuration) {
        if (lastDuration.compareTo(this.minimum.get()) < 0) {
            this.minimum.set(lastDuration);
        }
        if (lastDuration.compareTo(this.maximum.get()) > 0) {
            this.maximum.set(lastDuration);
        }
        this.total.accumulateAndGet(lastDuration, Duration::plus);
        this.count.incrementAndGet();
        this.average.set(this.total.get().dividedBy(this.count.get()));
        this.last.set(lastDuration);
        this.quantileMeter.addValue(lastDuration.toSeconds());
    }

    public synchronized void update(long value) {
        this.set(Duration.ofSeconds(value));
    }

    public Duration getMinValue() {
        return this.count.get() == 0L ? null : this.minimum.get();
    }

    public Duration getMaxValue() {
        return this.count.get() == 0L ? null : this.maximum.get();
    }

    public Duration getAverageValue() {
        return this.count.get() == 0L ? null : this.average.get();
    }

    public Duration getLastValue() {
        return this.count.get() == 0L ? null : this.last.get();
    }

    public Double getValueAtP50() {
        return this.quantileMeter.getValueAtQuantile(0.5);
    }

    public Double getValueAtP95() {
        return this.quantileMeter.getValueAtQuantile(0.95);
    }

    public Double getValueAtP99() {
        return this.quantileMeter.getValueAtQuantile(0.99);
    }
}

