/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.jmx;

import com.google.cloud.Timestamp;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.context.source.SpannerSourceTaskContext;
import io.debezium.connector.spanner.metrics.SpannerMeter;
import io.debezium.connector.spanner.metrics.jmx.JsonSerializer;
import io.debezium.connector.spanner.metrics.jmx.SpannerMetricsMXBean;
import io.debezium.data.Envelope;
import io.debezium.pipeline.metrics.DefaultStreamingChangeEventSourceMetrics;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.spi.schema.DataCollectionId;
import io.debezium.util.Collect;
import java.time.Duration;
import org.apache.kafka.connect.data.Struct;

public class SpannerStreamingChangeEventSourceMetrics
extends DefaultStreamingChangeEventSourceMetrics<SpannerPartition>
implements SpannerMetricsMXBean {
    private static final String TASK_ID_TAG = "Task";
    private static final String CONNECTOR_NAME_TAG = "ConnectorName";
    private static final String NOT_YET_CALCULATED = "not yet calculated";
    private final SpannerMeter spannerMeter;
    private final JsonSerializer jsonSerializer;

    public SpannerStreamingChangeEventSourceMetrics(SpannerSourceTaskContext taskContext, ChangeEventQueueMetrics changeEventQueueMetrics, EventMetadataProvider metadataProvider, SpannerMeter spannerMeter) {
        super((CdcSourceTaskContext)taskContext, changeEventQueueMetrics, metadataProvider, Collect.linkMapOf((Object)CONNECTOR_NAME_TAG, (Object)taskContext.getConnectorName(), (Object)TASK_ID_TAG, (Object)("Task-" + taskContext.getTaskId())));
        this.spannerMeter = spannerMeter;
        this.jsonSerializer = new JsonSerializer();
    }

    public void onEvent(SpannerPartition partition, DataCollectionId source, OffsetContext offset, Object key, Struct value, Envelope.Operation operation) {
        super.onEvent((Partition)partition, source, offset, key, value, operation);
        this.spannerMeter.captureTable(source);
    }

    public void reset() {
        super.reset();
        this.spannerMeter.reset();
    }

    @Override
    public String getLowWatermark() throws InterruptedException {
        Timestamp timestamp = this.spannerMeter.getLowWatermark();
        return timestamp != null ? timestamp.toString() : NOT_YET_CALCULATED;
    }

    @Override
    public Long getMilliSecondsLowWatermark() throws InterruptedException {
        Timestamp timestamp = this.spannerMeter.getLowWatermark();
        return timestamp != null ? Long.valueOf(timestamp.toSqlTimestamp().toInstant().toEpochMilli()) : null;
    }

    @Override
    public Long getMilliSecondsLowWatermarkLag() throws InterruptedException {
        return this.spannerMeter.getLowWatermarkLag();
    }

    @Override
    public int getNumberOfChangeStreamPartitionsDetected() {
        return this.spannerMeter.getNumberOfPartitionsDetected();
    }

    @Override
    public int getNumberOfChangeStreamQueriesIssuedTotal() {
        return this.spannerMeter.getNumberOfQueriesIssuedTotal();
    }

    @Override
    public int getNumberOfActiveChangeStreamQueries() {
        return this.spannerMeter.getNumberOfActiveQueries();
    }

    @Override
    public int getStuckHeartbeatIntervals() {
        return this.spannerMeter.getStuckHeartbeatIntervals();
    }

    @Override
    public Duration getDelayChangeStreamEventsLastMilliSeconds() {
        return this.spannerMeter.getDelayChangeStreamEvents().getLastValue();
    }

    @Override
    public Double getDelayChangeStreamEventsP50MilliSeconds() {
        return this.spannerMeter.getDelayChangeStreamEvents().getValueAtP50();
    }

    @Override
    public Double getDelayChangeStreamEventsP95MilliSeconds() {
        return this.spannerMeter.getDelayChangeStreamEvents().getValueAtP95();
    }

    @Override
    public Double getDelayChangeStreamEventsP99MilliSeconds() {
        return this.spannerMeter.getDelayChangeStreamEvents().getValueAtP99();
    }

    @Override
    public int getErrorCount() {
        return this.spannerMeter.getErrorCount();
    }

    @Override
    public String getTaskSyncContext() {
        return this.jsonSerializer.writeValueAsString(this.spannerMeter.getTaskSyncContext());
    }

    @Override
    public String getTaskUid() {
        return this.spannerMeter.getTaskUid();
    }

    @Override
    public Long getLatencyLowWatermarkLagMinMilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getMinValue().toMillis();
    }

    @Override
    public Long getLatencyLowWatermarkLagMaxMilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getMaxValue().toMillis();
    }

    @Override
    public Double getLatencyLowWatermarkLagAvgMilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getAverageValue().toMillis();
    }

    @Override
    public Double getLatencyLowWatermarkLagP50MilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyLowWatermarkLagP95MilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyLowWatermarkLagP99MilliSeconds() {
        return this.spannerMeter.getLowWatermarkLagLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyTotalMinMilliSeconds() {
        return this.spannerMeter.getTotalLatency().getMinValue().toMillis();
    }

    @Override
    public Long getLatencyTotalMaxMilliSeconds() {
        return this.spannerMeter.getTotalLatency().getMaxValue().toMillis();
    }

    @Override
    public Double getLatencyTotalAvgMilliSeconds() {
        return this.spannerMeter.getTotalLatency().getAverageValue().toMillis();
    }

    @Override
    public Double getLatencyTotalP50MilliSeconds() {
        return this.spannerMeter.getTotalLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyTotalP95MilliSeconds() {
        return this.spannerMeter.getTotalLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyTotalP99MilliSeconds() {
        return this.spannerMeter.getTotalLatency().getValueAtP99();
    }

    @Override
    public Long getLatencySpannerMinMilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getMinValue().toMillis();
    }

    @Override
    public Long getLatencySpannerMaxMilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getMaxValue().toMillis();
    }

    @Override
    public Double getLatencySpannerAvgMilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getAverageValue().toMillis();
    }

    @Override
    public Double getLatencySpannerP50MilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getValueAtP50();
    }

    @Override
    public Double getLatencySpannerP95MilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getValueAtP95();
    }

    @Override
    public Double getLatencySpannerP99MilliSeconds() {
        return this.spannerMeter.getSpannerLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyReadToEmitMinMilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getMinValue().toMillis();
    }

    @Override
    public Long getLatencyReadToEmitMaxMilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getMaxValue().toMillis();
    }

    @Override
    public Double getLatencyReadToEmitAvgMilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getAverageValue().toMillis();
    }

    @Override
    public Double getLatencyReadToEmitP50MilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyReadToEmitP95MilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyReadToEmitP99MilliSeconds() {
        return this.spannerMeter.getConnectorLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyCommitToEmitMinMilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getMinValue().toMillis();
    }

    @Override
    public Long getLatencyCommitToEmitMaxMilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getMaxValue().toMillis();
    }

    @Override
    public Double getLatencyCommitToEmitAvgMilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getAverageValue().toMillis();
    }

    @Override
    public Double getLatencyCommitToEmitP50MilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyCommitToEmitP95MilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyCommitToEmitP99MilliSeconds() {
        return this.spannerMeter.getCommitToEmitLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyCommitToPublishMinMilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getMinValue().toMillis();
    }

    @Override
    public Long getLatencyCommitToPublishMaxMilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getMaxValue().toMillis();
    }

    @Override
    public Double getLatencyCommitToPublishAvgMilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getAverageValue().toMillis();
    }

    @Override
    public Double getLatencyCommitToPublishP50MilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyCommitToPublishP95MilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyCommitToPublishP99MilliSeconds() {
        return this.spannerMeter.getCommitToPublishLatency().getValueAtP99();
    }

    @Override
    public Long getLatencyEmitToPublishMinMilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getMinValue().toMillis();
    }

    @Override
    public Long getLatencyEmitToPublishMaxMilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getMaxValue().toMillis();
    }

    @Override
    public Double getLatencyEmitToPublishAvgMilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getAverageValue().toMillis();
    }

    @Override
    public Double getLatencyEmitToPublishP50MilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getValueAtP50();
    }

    @Override
    public Double getLatencyEmitToPublishP95MilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getValueAtP95();
    }

    @Override
    public Double getLatencyEmitToPublishP99MilliSeconds() {
        return this.spannerMeter.getEmitToPublishLatency().getValueAtP99();
    }

    @Override
    public Long getDebugLatencyOwnConnectorMinMilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getMinValue().toMillis();
    }

    @Override
    public Long getDebugLatencyOwnConnectorMaxMilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getMaxValue().toMillis();
    }

    @Override
    public Double getDebugLatencyOwnConnectorAvgMilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getAverageValue().toMillis();
    }

    @Override
    public Long getDebugLatencyOwnConnectorLastMilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getLastValue().toMillis();
    }

    @Override
    public Double getDebugLatencyOwnConnectorP50MilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getValueAtP50();
    }

    @Override
    public Double getDebugLatencyOwnConnectorP95MilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getValueAtP95();
    }

    @Override
    public Double getDebugLatencyOwnConnectorP99MilliSeconds() {
        return this.spannerMeter.getOwnConnectorLatency().getValueAtP99();
    }

    @Override
    public Long getPartitionOffsetLagMinMilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getMinValue().toMillis();
    }

    @Override
    public Long getPartitionOffsetLagMaxMilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getMaxValue().toMillis();
    }

    @Override
    public Double getPartitionOffsetLagAvgMilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getAverageValue().toMillis();
    }

    @Override
    public Double getPartitionOffsetLagP50MilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getValueAtP50();
    }

    @Override
    public Double getPartitionOffsetLagP95MilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getValueAtP95();
    }

    @Override
    public Double getPartitionOffsetLagP99MilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getValueAtP99();
    }

    @Override
    public Long getPartitionOffsetLagLastMilliSeconds() {
        return this.spannerMeter.getPartitionOffsetLagStatistics().getLastValue().toMillis();
    }

    @Override
    public Long getOffsetReceivingTimeMinMilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getMinValue().toMillis();
    }

    @Override
    public Long getOffsetReceivingTimeMaxMilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getMaxValue().toMillis();
    }

    @Override
    public Double getOffsetReceivingTimeAvgMilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getAverageValue().toMillis();
    }

    @Override
    public Double getOffsetReceivingTimeP50MilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getValueAtP50();
    }

    @Override
    public Double getOffsetReceivingTimeP95MilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getValueAtP95();
    }

    @Override
    public Double getOffsetReceivingTimeP99MilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getValueAtP99();
    }

    @Override
    public Long getOffsetReceivingTimeLastMilliSeconds() {
        return this.spannerMeter.getOffsetReceivingTimeStatistics().getLastValue().toMillis();
    }

    @Override
    public int getSpannerEventQueueTotalCapacity() {
        return this.spannerMeter.getSpannerEventQueueTotalCapacity();
    }

    @Override
    public int getTaskStateChangeEventQueueRemainingCapacity() {
        return this.spannerMeter.getTaskStateChangeEventQueueRemainingCapacity();
    }

    @Override
    public int getSpannerEventQueueRemainingCapacity() {
        return this.spannerMeter.getSpannerEventQueueRemainingCapacity();
    }

    @Override
    public boolean isLeader() {
        return this.spannerMeter.isLeader();
    }

    @Override
    public long getRebalanceGenerationId() {
        return this.spannerMeter.getRebalanceGenerationId();
    }

    @Override
    public int getRebalanceAnswersActual() {
        return this.spannerMeter.getRebalanceAnswersActual();
    }

    @Override
    public int getRebalanceAnswersExpected() {
        return this.spannerMeter.getRebalanceAnswersExpected();
    }

    @Override
    public void finishTask() {
        this.spannerMeter.finishTask();
    }

    @Override
    public void restartTask() {
        this.spannerMeter.restartTask();
    }
}

