/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.schema;

import io.debezium.connector.spanner.db.metadata.TableId;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchema;
import io.debezium.connector.spanner.schema.KafkaSpannerTableSchemaFactory;
import io.debezium.schema.DataCollectionSchema;
import io.debezium.schema.DatabaseSchema;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class KafkaSpannerSchema
implements DatabaseSchema<TableId> {
    private final KafkaSpannerTableSchemaFactory tableSchemaFactory;
    private final Map<TableId, KafkaSpannerTableSchema> cache = new ConcurrentHashMap<TableId, KafkaSpannerTableSchema>();

    public KafkaSpannerSchema(KafkaSpannerTableSchemaFactory tableSchemaFactory) {
        this.tableSchemaFactory = tableSchemaFactory;
    }

    public DataCollectionSchema schemaFor(TableId tableId) {
        return this.cache.computeIfAbsent(tableId, this.tableSchemaFactory::getTableSchema);
    }

    public boolean tableInformationComplete() {
        return false;
    }

    public boolean isHistorized() {
        return false;
    }

    public void close() {
    }

    public void resetCache() {
        this.cache.clear();
    }
}

