/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.stream;

import io.debezium.util.Clock;
import io.debezium.util.Metronome;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionThreadPool.class);
    private final ConcurrentMap<String, Thread> threadMap = new ConcurrentHashMap<String, Thread>();
    private final Duration sleepInterval = Duration.ofMillis(100L);
    private final Clock clock = Clock.system();

    public boolean submit(String token, Runnable runnable) {
        this.clean();
        if (this.threadMap.containsKey(token)) {
            LOGGER.info("Failed to submit token in PartitionThreadPool {} since it is already contained in the map", (Object)token);
            return false;
        }
        AtomicBoolean insertedThread = new AtomicBoolean(false);
        this.threadMap.computeIfAbsent(token, k -> {
            Thread thread = new Thread(runnable, "SpannerConnector-PartitionThreadPool");
            thread.start();
            insertedThread.set(true);
            return thread;
        });
        if (!insertedThread.get()) {
            LOGGER.info("Failed to submit token in PartitionThreadPool {}", (Object)token);
        }
        return insertedThread.get();
    }

    public void stop(String token) {
        Thread thread = (Thread)this.threadMap.remove(token);
        if (thread != null) {
            LOGGER.info("Interrupting SpannerConnector-PartitionThreadPool");
            thread.interrupt();
        }
    }

    public void shutdown(String taskUid) {
        LOGGER.info("Trying to shut down partition thread pool for task {}", (Object)taskUid);
        this.clean();
        this.threadMap.values().forEach(Thread::interrupt);
        Metronome metronome = Metronome.sleeper((Duration)this.sleepInterval, (Clock)this.clock);
        while (!this.threadMap.isEmpty() && !this.threadMap.values().stream().allMatch(thread -> thread.getState().equals((Object)Thread.State.TERMINATED))) {
            try {
                this.clean();
                LOGGER.info("Still trying to shut down partition thread poll for task {} and threads {}", (Object)taskUid, this.threadMap.keySet());
                this.threadMap.values().forEach(Thread::interrupt);
                metronome.pause();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LOGGER.info("Beginning to terminate threads, task {}", (Object)taskUid);
        }
        LOGGER.info("Successfully shut down partition thread poll for task {}", (Object)taskUid);
        this.clean();
        LOGGER.info("Successfully cleaned partition thread poll for task {}", (Object)taskUid);
    }

    private void clean() {
        this.threadMap.entrySet().removeIf(entry -> ((Thread)entry.getValue()).getState().equals((Object)Thread.State.TERMINATED));
    }

    public Set<String> getActiveThreads() {
        this.clean();
        return Set.copyOf(this.threadMap.keySet());
    }
}

