/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal.model;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TaskState {
    private final String taskUid;
    private final String consumerId;
    private final long rebalanceGenerationId;
    private final long stateTimestamp;
    private final Map<String, PartitionState> partitions;
    private final Map<String, PartitionState> sharedPartitions;

    public static TaskStateBuilder builder() {
        return new TaskStateBuilder();
    }

    public TaskStateBuilder toBuilder() {
        return new TaskStateBuilder().taskUid(this.taskUid).consumerId(this.consumerId).rebalanceGenerationId(this.rebalanceGenerationId).stateTimestamp(this.stateTimestamp).partitionsMap(this.partitions).sharedPartitionsMap(this.sharedPartitions);
    }

    public TaskState(String taskUid, String consumerId, long rebalanceGenerationId, long stateTimestamp, Map<String, PartitionState> partitions, Map<String, PartitionState> sharedPartitions) {
        this.taskUid = taskUid;
        this.consumerId = consumerId;
        this.rebalanceGenerationId = rebalanceGenerationId;
        this.stateTimestamp = stateTimestamp;
        this.partitions = partitions;
        this.sharedPartitions = sharedPartitions;
    }

    public String getTaskUid() {
        return this.taskUid;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public long getRebalanceGenerationId() {
        return this.rebalanceGenerationId;
    }

    public long getStateTimestamp() {
        return this.stateTimestamp;
    }

    public Map<String, PartitionState> getPartitionsMap() {
        return this.partitions;
    }

    public Map<String, PartitionState> getSharedPartitionsMap() {
        return this.sharedPartitions;
    }

    public Collection<PartitionState> getPartitions() {
        return this.partitions.values();
    }

    public Collection<PartitionState> getSharedPartitions() {
        return this.sharedPartitions.values();
    }

    public String toString() {
        return "TaskState(taskUid=" + this.getTaskUid() + ", consumerId=" + this.getConsumerId() + ", rebalanceGenerationId=" + this.getRebalanceGenerationId() + ", stateTimestamp=" + this.getStateTimestamp() + ", partitions=" + String.valueOf(this.getPartitions()) + ", sharedPartitions=" + String.valueOf(this.getSharedPartitions()) + ")";
    }

    public static class TaskStateBuilder {
        private String taskUid;
        private String consumerId;
        private long rebalanceGenerationId;
        private long stateTimestamp;
        private Map<String, PartitionState> partitions;
        private Map<String, PartitionState> sharedPartitions;

        TaskStateBuilder() {
        }

        public TaskStateBuilder taskUid(String taskUid) {
            this.taskUid = taskUid;
            return this;
        }

        public TaskStateBuilder consumerId(String consumerId) {
            this.consumerId = consumerId;
            return this;
        }

        public TaskStateBuilder rebalanceGenerationId(long rebalanceGenerationId) {
            this.rebalanceGenerationId = rebalanceGenerationId;
            return this;
        }

        public TaskStateBuilder stateTimestamp(long stateTimestamp) {
            this.stateTimestamp = stateTimestamp;
            return this;
        }

        public TaskStateBuilder partitions(List<PartitionState> partitions) {
            this.partitions = partitions.stream().collect(Collectors.toMap(PartitionState::getToken, Function.identity()));
            return this;
        }

        public TaskStateBuilder sharedPartitions(List<PartitionState> sharedPartitions) {
            this.sharedPartitions = sharedPartitions.stream().collect(Collectors.toMap(PartitionState::getToken, Function.identity()));
            return this;
        }

        public TaskStateBuilder partitionsMap(Map<String, PartitionState> partitions) {
            this.partitions = partitions;
            return this;
        }

        public TaskStateBuilder sharedPartitionsMap(Map<String, PartitionState> sharedPartitions) {
            this.sharedPartitions = sharedPartitions;
            return this;
        }

        public TaskState build() {
            return new TaskState(this.taskUid, this.consumerId, this.rebalanceGenerationId, this.stateTimestamp, this.partitions, this.sharedPartitions);
        }

        public String toString() {
            return "TaskState.TaskStateBuilder(taskUid=" + this.taskUid + ", consumerId=" + this.consumerId + ", rebalanceGenerationId=" + this.rebalanceGenerationId + ", stateTimestamp=" + this.stateTimestamp + ", partitions=" + String.valueOf(this.partitions) + ", sharedPartitions=" + String.valueOf(this.sharedPartitions) + ")";
        }
    }
}

