/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.SpannerPartition;
import io.debezium.connector.spanner.context.offset.PartitionOffset;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.metrics.MetricsEventPublisher;
import io.debezium.connector.spanner.metrics.event.OffsetReceivingTimeMetricEvent;
import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.kafka.connect.storage.OffsetStorageReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionOffsetProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionOffsetProvider.class);
    private final OffsetStorageReader offsetStorageReader;
    private final MetricsEventPublisher metricsEventPublisher;
    private final ExecutorService executor;

    public PartitionOffsetProvider(OffsetStorageReader offsetStorageReader, MetricsEventPublisher metricsEventPublisher) {
        this.offsetStorageReader = offsetStorageReader;
        this.metricsEventPublisher = metricsEventPublisher;
        this.executor = Executors.newCachedThreadPool();
    }

    public Timestamp getOffset(PartitionState token) {
        Map<String, String> spannerPartition = new SpannerPartition(token.getToken()).getSourcePartition();
        Map<String, ?> result = this.retrieveOffsetMap(spannerPartition);
        if (result == null) {
            LOGGER.warn("Token {} returning start timestamp because no offset was retrieved", (Object)token);
            return token.getStartTimestamp();
        }
        LOGGER.info("Successfully retrieved offset {} for token {}", result, (Object)token);
        return PartitionOffset.extractOffset(result);
    }

    public Map<String, String> getOffsetMap(PartitionState token) {
        Map<String, String> spannerPartition = new SpannerPartition(token.getToken()).getSourcePartition();
        Map<String, String> result = this.retrieveOffsetMap(spannerPartition);
        if (result == null) {
            return Map.of();
        }
        return result;
    }

    public Map<String, Timestamp> getOffsets(Collection<String> partitions) {
        Instant startTime = Instant.now();
        List partitionsMapList = partitions.stream().map(token -> new SpannerPartition((String)token).getSourcePartition()).collect(Collectors.toList());
        Map result = this.offsetStorageReader.offsets(partitionsMapList);
        if (result == null) {
            return Map.of();
        }
        this.metricsEventPublisher.publishMetricEvent(OffsetReceivingTimeMetricEvent.from(startTime));
        HashMap<String, Timestamp> map = new HashMap<String, Timestamp>();
        for (Map.Entry entry : result.entrySet()) {
            map.put(SpannerPartition.extractToken((Map)entry.getKey()), PartitionOffset.extractOffset((Map)entry.getValue()));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ?> retrieveOffsetMap(Map<String, String> spannerPartition) {
        Instant startTime = Instant.now();
        Map result = null;
        Future future = this.executor.submit(new ExecutorServiceCallable(this.offsetStorageReader, spannerPartition));
        try {
            result = (Map)future.get(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException ex) {
            LOGGER.error("Token {}, failed to retrieve offset in time", spannerPartition, (Object)ex);
        }
        catch (InterruptedException e) {
            LOGGER.error("Token {},interrupting PartitionOffsetProvider", spannerPartition, (Object)e);
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            LOGGER.error("Token {}, failed to retrieve offset {}:{}", new Object[]{spannerPartition, e.toString(), e.getStackTrace()});
        }
        finally {
            future.cancel(true);
        }
        this.metricsEventPublisher.publishMetricEvent(OffsetReceivingTimeMetricEvent.from(startTime));
        return result;
    }

    public static class ExecutorServiceCallable
    implements Callable<Map<String, ?>> {
        private OffsetStorageReader offsetStorageReader;
        private Map<String, String> spannerPartition;

        public ExecutorServiceCallable(OffsetStorageReader offsetStorageReader, Map<String, String> spannerPartition) {
            this.offsetStorageReader = offsetStorageReader;
            this.spannerPartition = spannerPartition;
        }

        @Override
        public Map<String, ?> call() throws Exception {
            try {
                return this.offsetStorageReader.offset(this.spannerPartition);
            }
            catch (Exception e) {
                LOGGER.error("Offsetstoragereader throwing exception", (Throwable)e);
                throw e;
            }
        }
    }
}

