/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClearSharedPartitionOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClearSharedPartitionOperation.class);
    private boolean isRequiredPublishSyncEvent = false;

    private TaskSyncContext clear(TaskSyncContext taskSyncContext) {
        TaskState currentTaskState = taskSyncContext.getCurrentTaskState();
        Set otherTokens = taskSyncContext.getAllTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()).map(PartitionState::getToken).collect(Collectors.toSet());
        List currentSharedList = currentTaskState.getSharedPartitions().stream().collect(Collectors.toList());
        ArrayList<PartitionState> finalSharedList = new ArrayList<PartitionState>();
        for (PartitionState sharedToken : currentSharedList) {
            if (otherTokens.contains(sharedToken.getToken())) {
                LOGGER.info("Task {}, removing token {} since it is already owned by other tasks", (Object)taskSyncContext.getTaskUid(), (Object)sharedToken);
                continue;
            }
            finalSharedList.add(sharedToken);
        }
        if (finalSharedList.size() != currentSharedList.size()) {
            this.isRequiredPublishSyncEvent = true;
        }
        return taskSyncContext.toBuilder().currentTaskState(currentTaskState.toBuilder().sharedPartitions(finalSharedList).build()).build();
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return this.isRequiredPublishSyncEvent;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        return this.clear(taskSyncContext);
    }
}

