/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.metadata;

import io.debezium.connector.spanner.db.model.schema.Column;
import io.debezium.connector.spanner.db.model.schema.TableSchema;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaValidator.class);

    private SchemaValidator() {
    }

    public static boolean validate(TableSchema schemaTable, TableSchema watchedTable, List<Column> rowType) {
        String tableName = schemaTable.getName();
        for (Column column : rowType) {
            String columnName = tableName + "." + column.getName();
            Column schemaColumn = schemaTable.getColumn(column.getName());
            if (schemaColumn == null) {
                LOGGER.warn("Column not found in registry : {}", (Object)columnName);
                return false;
            }
            if (watchedTable.getColumn(schemaColumn.getName()) == null) {
                LOGGER.warn("ChangeStream doesn't watch column: {}", (Object)columnName);
                return false;
            }
            if (schemaColumn.isPrimaryKey() != column.isPrimaryKey()) {
                throw new IllegalStateException(columnName + " primary key data is incorrect in registry");
            }
            if (schemaColumn.getType().equals(column.getType())) continue;
            LOGGER.warn("{} type is incorrect in registry", (Object)columnName);
            return false;
        }
        return true;
    }
}

