/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.ConfigDefinition;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.spanner.SpannerSourceInfoStructMaker;
import io.debezium.connector.spanner.config.validation.FieldValidator;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.schema.AbstractTopicNamingStrategy;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;

public abstract class BaseSpannerConnectorConfig
extends CommonConnectorConfig {
    public static final String CONNECTOR_NAME_PROPERTY_NAME = "name";
    private static final String LOW_WATERMARK_ENABLED = "gcp.spanner.low-watermark.enabled";
    private static final String LOW_WATERMARK_UPDATE_PERIOD_MS = "gcp.spanner.low-watermark.update-period.ms";
    private static final String LOW_WATERMARK_STAMP_INTERVAL_NAME = "gcp.spanner.low-watermark.stamp.interval";
    private static final String TOPIC_DEFAULT_AUTO_CREATION_PARTITIONS_PROPERTY_NAME = "topic.creation.default.partitions";
    protected static final String GCP_SPANNER_PROJECT_ID_PROPERTY_NAME = "gcp.spanner.project.id";
    protected static final String GCP_SPANNER_DATABASE_ROLE_PROPERTY_NAME = "gcp.spanner.database.role";
    protected static final String GCP_SPANNER_INSTANCE_ID_PROPERTY_NAME = "gcp.spanner.instance.id";
    protected static final String GCP_SPANNER_DATABASE_ID_PROPERTY_NAME = "gcp.spanner.database.id";
    protected static final String GCP_SPANNER_HOST_PROPERTY_NAME = "gcp.spanner.host";
    protected static final String GCP_SPANNER_EMULATOR_HOST_PROPERTY_NAME = "gcp.spanner.emulator.host";
    protected static final String GCP_SPANNER_CHANGE_STREAM_PROPERTY_NAME = "gcp.spanner.change.stream";
    protected static final String START_TIME_PROPERTY_NAME = "gcp.spanner.start.time";
    protected static final String END_TIME_PROPERTY_NAME = "gcp.spanner.end.time";
    protected static final String GCP_SPANNER_CREDENTIALS_PATH_PROPERTY_NAME = "gcp.spanner.credentials.path";
    protected static final String GCP_SPANNER_CREDENTIALS_JSON_PROPERTY_NAME = "gcp.spanner.credentials.json";
    private static final String STREAM_EVENT_QUEUE_CAPACITY_PROPERTY_NAME = "gcp.spanner.stream.event.queue.capacity";
    private static final String TASK_STATE_CHANGE_EVENT_QUEUE_CAPACITY_PROPERTY_NAME = "connector.spanner.task.state.change.event.queue.capacity";
    private static final String VALUE_CAPTURE_MODE_PROPERTY_NAME = "gcp.spanner.value.capture.mode";
    private static final String TABLE_EXCLUDE_LIST_PROPERTY_NAME = "table.exclude.list";
    private static final String TABLE_INCLUDE_LIST_PROPERTY_NAME = "table.include.list";
    private static final String CONNECTOR_SPANNER_SYNC_TOPIC_PROPERTY_NAME = "connector.spanner.sync.topic";
    private static final String CONNECTOR_SPANNER_REBALANCING_TOPIC_PROPERTY_NAME = "connector.spanner.rebalancing.topic";
    private static final String CONNECTOR_SPANNER_REBALANCING_POLL_DURATION_PROPERTY_NAME = "connector.spanner.rebalancing.poll.duration";
    private static final String CONNECTOR_SPANNER_REBALANCING_COMMIT_OFFSETS_TIMEOUT_PROPERTY_NAME = "connector.spanner.rebalancing.commit.offsets.timeout";
    private static final String CONNECTOR_SPANNER_REBALANCING_COMMIT_OFFSET_INTERVAL_MS_PROPERTY_NAME = "connector.spanner.rebalancing.commit.offset.interval.ms";
    public static final String CONNECTOR_SPANNER_REBALANCING_TOPIC_CONFIG_PREFIX = "connector.spanner.rebalancing.topic.config.";
    private static final String CONNECTOR_SPANNER_SYNC_POLL_DURATION_PROPERTY_NAME = "connector.spanner.sync.poll.duration";
    private static final String CONNECTOR_SPANNER_SYNC_REQUEST_TIMEOUT_PROPERTY_NAME = "connector.spanner.sync.request.timeout.ms";
    private static final String CONNECTOR_SPANNER_SYNC_DELIVERY_TIMEOUT_PROPERTY_NAME = "connector.spanner.sync.delivery.timeout.ms";
    private static final String CONNECTOR_SPANNER_SYNC_COMMIT_OFFSETS_TIMEOUT_PROPERTY_NAME = "connector.spanner.sync.commit.offsets.timeout";
    private static final String CONNECTOR_SPANNER_SYNC_COMMIT_OFFSET_INTERVAL_MS_PROPERTY_NAME = "connector.spanner.sync.commit.offset.interval.ms";
    private static final String CONNECTOR_SPANNER_SYNC_CLEANUP_POLICY_PROPERTY_NAME = "connector.spanner.sync.cleanup.policy";
    private static final String CONNECTOR_SPANNER_SYNC_RETENTION_MS_PROPERTY_NAME = "connector.spanner.sync.retention.ms";
    private static final String CONNECTOR_SPANNER_SYNC_SEGMENT_MS_POLICY_PROPERTY_NAME = "connector.spanner.sync.segment.ms";
    private static final String CONNECTOR_SPANNER_SYNC_MIN_CLEANABLE_DIRTY_RATIO_PROPERTY_NAME = "connector.spanner.sync.min.cleanable.dirty.ratio";
    private static final String CONNECTOR_SPANNER_SYNC_KAFKA_BOOTSTRAP_SERVERS_PROPERTY_NAME = "connector.spanner.sync.kafka.bootstrap.servers";
    public static final String CONNECTOR_SPANNER_SYNC_TOPIC_CONFIG_PREFIX = "connector.spanner.sync.topic.config.";
    private static final String CONNECTOR_SPANNER_PARTITION_FINISHING_AFTER_COMMIT_PROPERTY_NAME = "connector.spanner.partition.finishing.afterCommit";
    private static final String CONNECTOR_SPANNER_FINISHED_PRTITION_DELETION_DELAY_PROPERTY_NAME = "connector.spanner.finished.partition.deletion.delay";
    private static final String CONNECTOR_SPANNER_REBALANCING_TASK_WAITING_TIMEOUT_PROPERTY_NAME = "connector.spanner.rebalancing.task.wait.timeout";
    private static final String CONNECTOR_SPANNER_SYNC_EVENT_PUBLISH_WAITING_TIMEOUT_PROPERTY_NAME = "connector.spanner.sync.publisher.wait.timeout";
    private static final String CONNECTOR_SPANNER_TASK_AWAIT_INITIALIZATION_TIMEOUT_PROPERTY_NAME = "connector.spanner.task.await.initialization.timeout";
    private static final String CONNECTOR_SPANNER_TASK_AWAIT_TASK_ANSWER_TIMEOUT_PROPERTY_NAME = "connector.spanner.task.await.task.answer.timeout";
    private static final String MAX_MISSED_HEARTBEATS_PROPERTY_NAME = "connector.spanner.max.missed.heartbeats";
    private static final String MAX_TASKS_PROPERTY_NAME = "tasks.max";
    private static final String MIN_TASKS_PROPERTY_NAME = "tasks.min";
    private static final String DESIRED_PARTITIONS_TASKS_PROPERTY_NAME = "tasks.desired.partitions";
    private static final String SCALER_MONITOR_ENABLED_PROPERTY_NAME = "scaler.monitor.enabled";
    private static final String LOGGING_JSON_ENABLED_PROPERTY_NAME = "logging.json.enabled";
    private static final String DEFAULT_SYNC_TOPIC_PREFIX = "_sync_topic_spanner_connector_";
    private static final String DEFAULT_REBALANCING_TOPIC_PREFIX = "_rebalancing_topic_spanner_connector_";
    private static final String CONNECTOR_NAME_TEMPLATE = "<connector_name>";
    public static final String KAFKA_INTERNAL_CLIENT_CONFIG_PREFIX = "kafka.internal.client.";
    private static final String PERCENTAGE_METRICS_CLEAR_INTERVAL_PROPERTY_NAME = "connector.spanner.metrics.percentage.clear.interval";
    private static final String TASKS_FAIL_OVERLOADED_PROPERTY_NAME = "tasks.fail.overloaded";
    private static final String TASKS_FAIL_OVERLOADED_CHECK_INTERVAL_PROPERTY_NAME = "tasks.fail.overloaded.check.interval";
    private static final String CONNECTOR_SPANNER_SYNC_TOPIC_MAX_MESSAGE_BYTES_PROPERTY_NAME = "connector.spanner.sync.max.message.bytes";
    protected static final Field LOW_WATERMARK_ENABLED_FIELD = Field.create((String)"gcp.spanner.low-watermark.enabled").withDisplayName("gcp.spanner.low-watermark.enabled").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(false).withDescription("Defines if low-watermarks are enabled or not, default false");
    protected static final Field LOW_WATERMARK_UPDATE_PERIOD_MS_FIELD = Field.create((String)"gcp.spanner.low-watermark.update-period.ms").withDisplayName("gcp.spanner.low-watermark.update-period.ms").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(1000L).withDescription("Low-watermark update period for each task, default 1000 ms.");
    public static final Field PROJECT_ID = Field.create((String)"gcp.spanner.project.id").withDisplayName("ProjectId").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{FieldValidator::isNotBlank}).withDescription("Spanner project id");
    public static final Field INSTANCE_ID = Field.create((String)"gcp.spanner.instance.id").withDisplayName("InstanceId").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{FieldValidator::isNotBlank}).withDescription("Spanner instance id");
    public static final Field DATABASE_ID = Field.create((String)"gcp.spanner.database.id").withDisplayName("DatabaseId").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{FieldValidator::isNotBlank}).withDescription("Spanner database id");
    public static final Field DATABASE_ROLE = Field.create((String)"gcp.spanner.database.role").withDisplayName("DatabaseRole").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)5)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Spanner database role");
    public static final Field CHANGE_STREAM_NAME = Field.create((String)"gcp.spanner.change.stream").withDisplayName("Change stream name").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)6)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{FieldValidator::isNotBlank}).withDescription("Spanner change stream name");
    public static final Field SPANNER_HOST = Field.create((String)"gcp.spanner.host").withDisplayName("SpannerHost").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)7)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Spanner host");
    public static final Field SPANNER_EMULATOR_HOST = Field.create((String)"gcp.spanner.emulator.host").withDisplayName("SpannerEmulatorHost").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)7)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Spanner emulator host");
    public static final Field SPANNER_CREDENTIALS_PATH = Field.create((String)"gcp.spanner.credentials.path").withDisplayName("gcp.spanner.credentials.path").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)1)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{FieldValidator::isCorrectPath}).withDescription("Service account keys file path");
    public static final Field SPANNER_CREDENTIALS_JSON = Field.create((String)"gcp.spanner.credentials.json").withDisplayName("gcp.spanner.credentials.json").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)2)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{FieldValidator::isCorrectJson}).withDescription("Service account keys with json format");
    public static final Field STREAM_EVENT_QUEUE_CAPACITY = Field.create((String)"gcp.spanner.stream.event.queue.capacity").withDisplayName("Change steam queue capacity").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)3)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(10000).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Change stream event queue capacity");
    public static final Field TASK_STATE_CHANGE_EVENT_QUEUE_CAPACITY = Field.create((String)"connector.spanner.task.state.change.event.queue.capacity").withDisplayName("Task state change event queue capacity").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)4)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(1000).withValidation(new Field.Validator[]{Field::isPositiveInteger}).withDescription("Task state change event queue capacity");
    public static final Field START_TIME = Field.create((String)"gcp.spanner.start.time").withDisplayName("Start time").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)7)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{FieldValidator::isCorrectDateTime}).withDescription("Start change stream time");
    public static final Field END_TIME = Field.create((String)"gcp.spanner.end.time").withDisplayName("End time").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)8)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{FieldValidator::isCorrectDateTime}).withDescription("End change stream time");
    public static final Field SPANNER_HEART_BEAT_INTERVAL = Heartbeat.HEARTBEAT_INTERVAL.withValidation(new Field.Validator[]{FieldValidator::isCorrectHeartBeatInterval}).withDefault(300000);
    protected static final Field LOW_WATERMARK_STAMP_INTERVAL = Field.create((String)"gcp.spanner.low-watermark.stamp.interval").withDisplayName("Low watermark stamp interval (milli-seconds)").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)0)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Length of an interval in milli-seconds in in which the connector periodically sends low watermark stamp messages to all table topics and all kafka partitions").withDefault(10000).withValidation(new Field.Validator[]{Field::isNonNegativeInteger});
    protected static final Field TOPIC_DEFAULT_AUTO_CREATION_PARTITIONS_FIELD = Field.create((String)"topic.creation.default.partitions").withDisplayName("Topic auto creation num partitions").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)10)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(1).withDescription("Number of partitions in automatically created topic");
    protected static final Field MAX_MISSED_HEARTBEATS = Field.create((String)"connector.spanner.max.missed.heartbeats").withDisplayName("Maximum missed heartbeats to identify that partition gets stuck").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTION_ADVANCED, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDescription("Maximum missed heartbeats to identify that partition gets stuck").withDefault(10).withValidation(new Field.Validator[]{Field::isNonNegativeInteger});
    private static final Field VALUE_CAPTURE_MODE = Field.create((String)"gcp.spanner.value.capture.mode").withDisplayName("Value capture mode").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR_ADVANCED, (int)0)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{FieldValidator::isCorrectCaptureMode}).withDefault("OLD_AND_NEW_VALUES").withDescription("Value capture mode");
    protected static final Field TABLE_INCLUDE_LIST = Field.create((String)"table.include.list").withDisplayName("Include Tables").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)0)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("The tables for which changes are to be captured");
    protected static final Field TABLE_EXCLUDE_LIST = Field.create((String)"table.exclude.list").withDisplayName("Exclude Tables").withType(ConfigDef.Type.LIST).withGroup(Field.createGroupEntry((Field.Group)Field.Group.FILTERS, (int)1)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("A comma-separated list of regular expressions that match the fully-qualified names of tables to be excluded from monitoring");
    protected static final Field SYNC_TOPIC = Field.create((String)"connector.spanner.sync.topic").withDisplayName("Sync Topic Prefix").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)20)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault("_sync_topic_spanner_connector_").withDescription("Connector Sync topic name, default _sync_topic_spanner_connector_<connector_name>");
    protected static final Field REBALANCING_TOPIC = Field.create((String)"connector.spanner.rebalancing.topic").withDisplayName("Rebalancing Topic Prefix").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)21)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault("_rebalancing_topic_spanner_connector_").withDescription("Connector Rebalancing topic name, default _rebalancing_topic_spanner_connector_<connector_name>");
    protected static final Field REBALANCING_POLL_DURATION = Field.create((String)"connector.spanner.rebalancing.poll.duration").withDisplayName("Rebalancing Topic Poll Duration").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)25)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5000).withDescription("Connector rebalancing topic poll duration, default 5000 ms");
    protected static final Field REBALANCING_COMMIT_OFFSETS_TIMEOUT = Field.create((String)"connector.spanner.rebalancing.commit.offsets.timeout").withDisplayName("Rebalancing Topic Commit Offsets Timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)26)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5000).withDescription("Connector rebalancing topic commit offsets timeout, default 5000 ms");
    protected static final Field SYNC_POLL_DURATION = Field.create((String)"connector.spanner.sync.poll.duration").withDisplayName("Sync Topic Poll Duration").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)27)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(500).withDescription("Connector sync topic poll duration, default 500 ms");
    protected static final Field SYNC_COMMIT_OFFSETS_TIMEOUT = Field.create((String)"connector.spanner.sync.commit.offsets.timeout").withDisplayName("Sync Topic Commit Offsets Timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)28)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5000).withDescription("Connector sync topic commit offsets timeout, default 5000 ms");
    protected static final Field SYNC_KAFKA_BOOTSTRAP_SERVERS = Field.create((String)"connector.spanner.sync.kafka.bootstrap.servers").withDisplayName("Sync Kafka Bootstrap Servers").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)30)).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("Kafka bootstrapServers for synchronization between tasks");
    protected static final Field SYNC_REQUEST_TIMEOUT = Field.create((String)"connector.spanner.sync.request.timeout.ms").withDisplayName("Sync Request Timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)31)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5000).withDescription("Connector Sync topic property: request.timeout.ms, default 5000 ms");
    protected static final Field SYNC_DELIVERY_TIMEOUT = Field.create((String)"connector.spanner.sync.delivery.timeout.ms").withDisplayName("Sync Delivery Timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)32)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(15000).withDescription("Connector Sync topic property: delivery.timeout.ms, default 15000 ms");
    protected static final Field SYNC_CLEANUP_POLICY = Field.create((String)"connector.spanner.sync.cleanup.policy").withDisplayName("Sync Topic property: cleanup.policy").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)33)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault("delete").withDescription("Sync Topic property: cleanup.policy, default: delete");
    protected static final Field SYNC_RETENTION_MS = Field.create((String)"connector.spanner.sync.retention.ms").withDisplayName("Sync Topic property: retention.ms").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)34)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(86400000).withDescription("Sync Topic property: retention.ms, default: 86400000 (24h)");
    protected static final Field SYNC_SEGMENT_MS = Field.create((String)"connector.spanner.sync.segment.ms").withDisplayName("Sync Topic property: segment.ms").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)35)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(43200000).withDescription("Sync Topic property: segment.ms, default: 43200000 (12h)");
    protected static final Field SYNC_MIN_CLEANABLE_DIRTY_RATIO = Field.create((String)"connector.spanner.sync.min.cleanable.dirty.ratio").withDisplayName("Sync Topic property: min.cleanable.dirty.ratio").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)36)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault("0.1").withDescription("Sync Topic property: min.cleanable.dirty.ratio, default: 0.1");
    protected static final Field SYNC_COMMIT_OFFSETS_INTERVAL_MS = Field.create((String)"connector.spanner.sync.commit.offset.interval.ms").withDisplayName("Sync Topic Commit Offsets Interval").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)37)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(60000).withDescription("Connector sync topic commit offsets interval, default 60000 ms");
    protected static final Field REBALANCING_COMMIT_OFFSETS_INTERVAL_MS = Field.create((String)"connector.spanner.rebalancing.commit.offset.interval.ms").withDisplayName("Rebalancing Topic Commit Offsets Interval").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)38)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(60000).withDescription("Connector rebalancing topic commit offsets interval, default 60000 ms");
    protected static final Field TASKS_FAIL_OVERLOADED = Field.create((String)"tasks.fail.overloaded").withDisplayName("Fail Overloaded Task").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)39)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(false).withDescription("Task will be failed, if it is overloaded by partitions");
    protected static final Field TASKS_FAIL_OVERLOADED_CHECK_INTERVAL = Field.create((String)"tasks.fail.overloaded.check.interval").withDisplayName("Check Interval for \"Fail Overloaded Task\"").withType(ConfigDef.Type.LONG).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)40)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5000).withDescription("Interval in milliseconds to check whether the task is overloaded by partitions");
    protected static final Field MAX_TASKS = Field.create((String)"tasks.max").withDisplayName("Max Tasks").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)10)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(10).withDescription("Maximum number of tasks in connector");
    protected static final Field MIN_TASKS = Field.create((String)"tasks.min").withDisplayName("Min Tasks").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)11)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(2).withDescription("Minimum number of tasks in connector");
    protected static final Field DESIRED_PARTITIONS_TASKS = Field.create((String)"tasks.desired.partitions").withDisplayName("Desired partitions per task").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)12)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault(2).withDescription("Connector will increase task number, if actual partitions per task ratio become > desired up to tasks.max bound");
    protected static final Field SCALER_MONITOR_ENABLED = Field.create((String)"scaler.monitor.enabled").withDisplayName("Scaler monitor enabled").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)13)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withDescription("Defines if Scaler Monitor enabled or not, default false");
    protected static final Field LOGGING_JSON_ENABLED = Field.create((String)"logging.json.enabled").withDisplayName("Logging json enabled").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)13)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(false).withDescription("Defines if json logging enabled or not, default false");
    protected static final Field CONNECTOR_SPANNER_PARTITION_FINISHING_AFTER_COMMIT_FIELD = Field.create((String)"connector.spanner.partition.finishing.afterCommit").withDisplayName("Connector spanner partition finishing after commit strategy").withType(ConfigDef.Type.BOOLEAN).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)14)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withDescription("default true");
    protected static final Field CONNECTOR_SPANNER_FINISHED_PARTITION_DELETION_DELAY_FIELD = Field.create((String)"connector.spanner.finished.partition.deletion.delay").withDisplayName("Connector spanner partition deletion delay after finished(seconds)").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)14)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(7200).withDescription("Defines deletion delay after partitions finished, default 2 hours");
    protected static final Field REBALANCING_TASK_WAITING_TIMEOUT = Field.create((String)"connector.spanner.rebalancing.task.wait.timeout").withDisplayName("Rebalancing Task waiting timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)16)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(1000).withDescription("Connector rebalancing task waiting timeout, default 1000 ms");
    protected static final Field SYNC_EVENT_PUBLISH_WAITING_TIMEOUT = Field.create((String)"connector.spanner.sync.publisher.wait.timeout").withDisplayName("Sync Event Publisher waiting timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)17)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(5).withDescription("Connector rebalancing task waiting timeout, default 5 ms");
    protected static final Field TASK_AWAIT_INITIALIZATION_TMEOUT = Field.create((String)"connector.spanner.task.await.initialization.timeout").withDisplayName("Task await initialization timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)16)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(120000).withDescription("Connector task await initialization timeout, default 120000 ms");
    protected static final Field TASK_AWAIT_ANSWER_TIMEOUT = Field.create((String)"connector.spanner.task.await.task.answer.timeout").withDisplayName("Task await answer timeout").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)16)).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDefault(120000).withDescription("Connector leader task await answer timeout, default 120000 ms");
    protected static final Field PERCENTAGE_METRICS_CLEAR_INTERVAL = Field.create((String)"connector.spanner.metrics.percentage.clear.interval").withDisplayName("Percentage metrics clear interval").withType(ConfigDef.Type.INT).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)18)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.LOW).withDefault(10000).withDescription("Percentage metrics clear interval");
    protected static final Field SYNC_TOPIC_MAX_MESSAGE_BYTES = Field.create((String)"connector.spanner.sync.max.message.bytes").withDisplayName("Sync topic max message size").withType(ConfigDef.Type.STRING).withGroup(Field.createGroupEntry((Field.Group)Field.Group.CONNECTOR, (int)19)).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDefault("10485880").withDescription("Sync topic max message size");
    public static final Field SOURCE_INFO_STRUCT_MAKER = CommonConnectorConfig.SOURCE_INFO_STRUCT_MAKER.withDefault(SpannerSourceInfoStructMaker.class.getName());
    protected static final ConfigDefinition CONFIG_DEFINITION = ConfigDefinition.editor().name("Spanner").type(new Field[]{PROJECT_ID}).connector(new Field[]{INSTANCE_ID, DATABASE_ID, DATABASE_ROLE, CHANGE_STREAM_NAME, START_TIME, END_TIME, SPANNER_CREDENTIALS_PATH, SPANNER_CREDENTIALS_JSON, SPANNER_HOST, SPANNER_EMULATOR_HOST, STREAM_EVENT_QUEUE_CAPACITY, TASK_STATE_CHANGE_EVENT_QUEUE_CAPACITY, VALUE_CAPTURE_MODE, SPANNER_HEART_BEAT_INTERVAL, TOPIC_DEFAULT_AUTO_CREATION_PARTITIONS_FIELD, MAX_BATCH_SIZE, MAX_QUEUE_SIZE, POLL_INTERVAL_MS, MAX_QUEUE_SIZE_IN_BYTES, SKIPPED_OPERATIONS, QUERY_FETCH_SIZE, REBALANCING_TOPIC, REBALANCING_POLL_DURATION, REBALANCING_COMMIT_OFFSETS_TIMEOUT, REBALANCING_COMMIT_OFFSETS_INTERVAL_MS, REBALANCING_TASK_WAITING_TIMEOUT, SYNC_EVENT_PUBLISH_WAITING_TIMEOUT, TASK_AWAIT_INITIALIZATION_TMEOUT, TASK_AWAIT_ANSWER_TIMEOUT, CONNECTOR_SPANNER_PARTITION_FINISHING_AFTER_COMMIT_FIELD, CONNECTOR_SPANNER_FINISHED_PARTITION_DELETION_DELAY_FIELD, PERCENTAGE_METRICS_CLEAR_INTERVAL, SYNC_TOPIC, SYNC_KAFKA_BOOTSTRAP_SERVERS, SYNC_POLL_DURATION, SYNC_COMMIT_OFFSETS_TIMEOUT, SYNC_COMMIT_OFFSETS_INTERVAL_MS, SYNC_REQUEST_TIMEOUT, SYNC_DELIVERY_TIMEOUT, SYNC_CLEANUP_POLICY, SYNC_RETENTION_MS, SYNC_SEGMENT_MS, SYNC_MIN_CLEANABLE_DIRTY_RATIO, MAX_TASKS, MIN_TASKS, DESIRED_PARTITIONS_TASKS, TASKS_FAIL_OVERLOADED, TASKS_FAIL_OVERLOADED_CHECK_INTERVAL, SCALER_MONITOR_ENABLED, LOGGING_JSON_ENABLED}).events(new Field[]{TABLE_EXCLUDE_LIST, TABLE_INCLUDE_LIST, CUSTOM_CONVERTERS, TOMBSTONES_ON_DELETE, AbstractTopicNamingStrategy.TOPIC_HEARTBEAT_PREFIX, SOURCE_INFO_STRUCT_MAKER}).create();
    private static final int POLL_INTERVAL_IN_MS = 25;
    protected final String startTime = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
    public static final Field.Set ALL_FIELDS = Field.setOf((Iterable)CONFIG_DEFINITION.all());

    protected BaseSpannerConnectorConfig(Configuration config, String logicalName, int defaultSnapshotFetchSize) {
        super(((Configuration.Builder)((Configuration.Builder)Configuration.from((Properties)config.asProperties()).edit().with(CommonConnectorConfig.TOPIC_PREFIX, logicalName)).with(CommonConnectorConfig.POLL_INTERVAL_MS, 25)).build(), defaultSnapshotFetchSize);
    }

    public static ConfigDef configDef() {
        return CONFIG_DEFINITION.configDef();
    }
}

