/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.jmx;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JSR310Module;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonSerializer.class);
    private final ObjectMapper objectMapper = new ObjectMapper().registerModule((Module)new JSR310Module()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);

    public String writeValueAsString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException ex) {
            LOGGER.warn("Error serialize object: " + obj, (Throwable)ex);
            return "Error serialize object: " + obj;
        }
    }
}

