/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.task.TaskUid;
import io.debezium.function.BlockingConsumer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinishingPartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishingPartitionManager.class);
    private final BlockingConsumer<String> finishedPartitionConsumer;
    private final SpannerConnectorConfig connectorConfig;
    private final Map<String, String> lastEmittedRecord = new ConcurrentHashMap<String, String>();
    private final Map<String, Boolean> partitionPendingFinish = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, String> lastCommittedRecord = new ConcurrentHashMap<String, String>();
    private volatile String taskUid;

    public FinishingPartitionManager(SpannerConnectorConfig connectorConfig, BlockingConsumer<String> finishedPartitionConsumer) {
        this.finishedPartitionConsumer = finishedPartitionConsumer;
        this.connectorConfig = connectorConfig;
        this.taskUid = "";
        if (connectorConfig != null) {
            this.taskUid = TaskUid.generateTaskUid(connectorConfig.getConnectorName(), connectorConfig.getTaskId());
        }
    }

    public String newRecord(String token) {
        String recordUid = this.lastEmittedRecord.get(token) == null ? "aaaaaaaa" : this.next(this.lastEmittedRecord.get(token));
        this.lastEmittedRecord.put(token, recordUid);
        return recordUid;
    }

    public void registerPartition(String token) {
        this.partitionPendingFinish.put(token, false);
    }

    public void commitRecord(String token, String recordUid) throws InterruptedException {
        Boolean pendingFinishFlag = this.partitionPendingFinish.get(token);
        if (pendingFinishFlag == null) {
            LOGGER.warn("Task: {}, Partition has not been registered to finish or already finished {} for task {}", (Object)this.taskUid, (Object)token);
            return;
        }
        if (!pendingFinishFlag.booleanValue()) {
            if (this.lastCommittedRecord.get(token) == null) {
                this.lastCommittedRecord.put(token, recordUid);
            } else if (recordUid.compareTo(this.lastCommittedRecord.get(token)) > 0) {
                this.lastCommittedRecord.put(token, recordUid);
            }
            return;
        }
        if (this.lastEmittedRecord.get(token) == null || this.lastEmittedRecord.get(token).equals(recordUid)) {
            LOGGER.info("Task: {}, Finished forcing the token to be finished {}", (Object)this.taskUid, (Object)token);
            this.forceFinish(token);
        }
    }

    public void onPartitionFinishEvent(String token) throws InterruptedException {
        LOGGER.info("Task: {}, onPartitionFinishEvent: {}", (Object)this.taskUid, (Object)token);
        Boolean pendingFinishFlag = this.partitionPendingFinish.get(token);
        if (pendingFinishFlag == null) {
            LOGGER.warn("Task: {}, Partition has not been registered to finish or already finished {}", (Object)this.taskUid, (Object)token);
            return;
        }
        if (this.lastEmittedRecord.get(token) == null || this.lastEmittedRecord.get(token).equals(this.lastCommittedRecord.get(token))) {
            LOGGER.info("Task: {}, Forcing the token to be finished {}", (Object)this.taskUid, (Object)token);
            this.forceFinish(token);
            LOGGER.info("Task: {}, Done forcing the token to be finished {}", (Object)this.taskUid, (Object)token);
        } else {
            LOGGER.info("Task: {}, Cannot finish the token {} due to lastCommittedRecord {} not being equal to lastEmittedRecord {}", new Object[]{this.taskUid, token, this.lastCommittedRecord.get(token), this.lastEmittedRecord.get(token)});
            this.partitionPendingFinish.put(token, true);
        }
    }

    public void forceFinish(String token) throws InterruptedException {
        this.finishedPartitionConsumer.accept((Object)token);
        this.partitionPendingFinish.remove(token);
        this.lastEmittedRecord.remove(token);
        this.lastCommittedRecord.remove(token);
    }

    public Set<String> getPendingFinishPartitions() {
        return this.partitionPendingFinish.entrySet().stream().filter(entry -> ((Boolean)entry.getValue()).equals(true)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getPendingPartitions() {
        return this.partitionPendingFinish.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    private String next(String str) {
        int i;
        if (((String)str).isEmpty()) {
            return "a";
        }
        for (i = ((String)str).length() - 1; i >= 0 && ((String)str).charAt(i) == 'z'; --i) {
        }
        if (i == -1) {
            str = (String)str + "a";
        } else {
            Object suffix = "";
            for (int j = i + 1; j < ((String)str).length(); ++j) {
                suffix = (String)suffix + "a";
            }
            str = ((String)str).substring(0, i) + (char)(((String)str).charAt(i) + '\u0001') + (String)suffix;
        }
        return str;
    }
}

