/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.config.validation;

import com.google.auth.oauth2.ServiceAccountCredentials;
import io.debezium.connector.spanner.config.BaseSpannerConnectorConfig;
import io.debezium.connector.spanner.config.validation.ConfigurationValidator;
import io.debezium.connector.spanner.config.validation.FieldValidator;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionValidator
implements ConfigurationValidator.Validator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionValidator.class);
    private static final String GOOGLE_APPLICATION_CREDENTIALS_ENV_VAR = "GOOGLE_APPLICATION_CREDENTIALS";
    private static final String PLEASE_SPECIFY_CONFIGURATION_PROPERTY_MSG = "Configuration property %s or %s is not specified; Application Default Credentials will be used.";
    private static final String GOOGLE_CREDENTIAL_INCORRECT = "Can`t connect to spanner. Google credential is incorrect";
    private static final String INSTANCE_NOT_EXIST = "Instance %s does not exist";
    private static final String CONNECTOR_NOT_SUPPORT_POSTGRESQL_DIALECT = "Spanner connector doesn't support PostgreSql dialect";
    private static final String DATABASE_ID_NOT_EXIST = "Database %s does not exist";
    private final ConfigurationValidator.ValidationContext context;
    private boolean result = true;

    private ConnectionValidator(ConfigurationValidator.ValidationContext context) {
        this.context = context;
    }

    public static ConnectionValidator withContext(ConfigurationValidator.ValidationContext validationContext) {
        return new ConnectionValidator(validationContext);
    }

    @Override
    public ConnectionValidator validate() {
        if (!this.canValidate()) {
            this.result = false;
            return this;
        }
        String googleCredentials = System.getenv().get(GOOGLE_APPLICATION_CREDENTIALS_ENV_VAR);
        String credentialPath = this.context.getString(BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_PATH);
        String credentialJson = this.context.getString(BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_JSON);
        if (!(FieldValidator.isSpecified(googleCredentials) || FieldValidator.isSpecified(credentialPath) || FieldValidator.isSpecified(credentialJson))) {
            try {
                ServiceAccountCredentials.getApplicationDefault();
            }
            catch (IOException e) {
                LOGGER.error("The Application Default Credentials are not available.", (Throwable)e);
                this.result = false;
                return this;
            }
            String message = String.format(PLEASE_SPECIFY_CONFIGURATION_PROPERTY_MSG, BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_PATH.name(), BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_JSON.name(), GOOGLE_APPLICATION_CREDENTIALS_ENV_VAR);
            LOGGER.info(message, (Object)BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_PATH, (Object)BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_JSON);
        }
        return this;
    }

    @Override
    public boolean isSuccess() {
        return this.result;
    }

    public boolean canValidate() {
        return this.context.getErrors(BaseSpannerConnectorConfig.PROJECT_ID).isEmpty() && this.context.getErrors(BaseSpannerConnectorConfig.INSTANCE_ID).isEmpty() && this.context.getErrors(BaseSpannerConnectorConfig.DATABASE_ID).isEmpty() && this.context.getErrors(BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_JSON).isEmpty() && this.context.getErrors(BaseSpannerConnectorConfig.SPANNER_CREDENTIALS_PATH).isEmpty();
    }
}

