/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka.internal;

import io.debezium.connector.spanner.SpannerConnectorTask;
import io.debezium.connector.spanner.exception.SpannerConnectorException;
import io.debezium.connector.spanner.kafka.internal.RebalancingConsumerFactory;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceEventMetadata;
import io.debezium.connector.spanner.task.utils.ResettableDelayedAction;
import io.debezium.function.BlockingConsumer;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InterruptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RebalancingEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(RebalancingEventListener.class);
    private final String consumerGroup;
    private final String topic;
    private final Duration pollDuration;
    private final Duration commitOffsetsTimeout;
    private final long commitOffsetsInterval;
    private final RebalancingConsumerFactory<?, ?> consumerFactory;
    private final java.util.function.Consumer<RuntimeException> errorHandler;
    private volatile Consumer<?, ?> consumer;
    private volatile Thread thread;
    private volatile BlockingConsumer<RebalanceEventMetadata> rebalancingAction;
    private final ResettableDelayedAction resettableDelayedAction;
    private volatile RebalanceEventMetadata lastRebalanceEventMetadata;
    private final SpannerConnectorTask task;

    public RebalancingEventListener(SpannerConnectorTask task, String consumerGroup, String topic, Duration rebalancingTaskWaitingTimeout, RebalancingConsumerFactory<?, ?> consumerFactory, java.util.function.Consumer<RuntimeException> errorHandler) {
        this.task = task;
        this.consumerGroup = consumerGroup;
        this.topic = topic;
        this.pollDuration = Duration.ofMillis(consumerFactory.getConfig().rebalancingPollDuration());
        this.commitOffsetsTimeout = Duration.ofMillis(consumerFactory.getConfig().rebalancingCommitOffsetsTimeout());
        this.commitOffsetsInterval = consumerFactory.getConfig().rebalancingCommitOffsetsInterval();
        this.consumerFactory = consumerFactory;
        this.errorHandler = errorHandler;
        this.resettableDelayedAction = new ResettableDelayedAction("rebalance-delayed-action", rebalancingTaskWaitingTimeout);
    }

    public void listen(BlockingConsumer<RebalanceEventMetadata> action) {
        this.rebalancingAction = action;
        this.consumer = this.consumerFactory.createSubscribeConsumer(this.consumerGroup, this.topic, new ConsumerRebalanceListener(){

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                ConsumerGroupMetadata meta = RebalancingEventListener.this.consumer.groupMetadata();
                LOGGER.info("Task {} - Rebalance happened, consumer ID {}, partitions {}", new Object[]{RebalancingEventListener.this.task.getTaskUid(), meta.memberId(), partitions.stream().map(partition -> partition.partition()).collect(Collectors.toList())});
                RebalancingEventListener.this.lastRebalanceEventMetadata = new RebalanceEventMetadata(meta.memberId(), meta.generationId(), RebalancingEventListener.this.isLeader(partitions));
                LOGGER.info("Task {} - Rebalance: Waiting for other tasks to connect", (Object)RebalancingEventListener.this.task.getTaskUid());
                RebalancingEventListener.this.resettableDelayedAction.set(() -> {
                    LOGGER.info("Task {} -Rebalance finished with consumer Id {}", (Object)RebalancingEventListener.this.task.getTaskUid(), (Object)meta.memberId());
                    try {
                        RebalancingEventListener.this.rebalancingAction.accept((Object)RebalancingEventListener.this.lastRebalanceEventMetadata);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        LOGGER.error("Task {} - rebalance error with consumer ID {}", (Object)RebalancingEventListener.this.task.getTaskUid(), (Object)meta.memberId());
                    }
                });
            }

            public void onPartitionsLost(Collection<TopicPartition> partitions) {
            }
        });
        this.thread = new Thread(() -> {
            try {
                long commitOffsetStart = System.currentTimeMillis();
                Instant lastUpdatedTime = Instant.now();
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        this.consumer.poll(this.pollDuration);
                        if (commitOffsetStart + this.commitOffsetsInterval < System.currentTimeMillis()) {
                            this.consumer.commitSync(this.commitOffsetsTimeout);
                            commitOffsetStart = System.currentTimeMillis();
                        }
                        if (!Instant.now().isAfter(lastUpdatedTime.plus(Duration.ofSeconds(600L)))) continue;
                        LOGGER.info("Task Uid {} is still listening to RebalanceEventListener", (Object)this.task.getTaskUid());
                        lastUpdatedTime = Instant.now();
                    }
                    catch (InterruptException e) {
                        LOGGER.error("Task Uid {} caught exception when interrupting RebalancingEventListener", (Throwable)e);
                        Thread.currentThread().interrupt();
                        try {
                            LOGGER.info("Task {} - unsubscribing rebalance handling consumer", (Object)this.task.getTaskUid());
                            this.consumer.unsubscribe();
                            LOGGER.info("Task {} - closing rebalance handling consumer", (Object)this.task.getTaskUid());
                            this.consumer.close();
                            LOGGER.info("Task {} - finished closing rebalance handling consumer", (Object)this.task.getTaskUid());
                            return;
                        }
                        catch (InterruptException e2) {
                            LOGGER.error("Task Uid {} caught exception when interrupting RebalancingEventListener", (Object)this.task.getTaskUid(), (Object)e2);
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
            }
            finally {
                try {
                    LOGGER.info("Task {} - unsubscribing rebalance handling consumer", (Object)this.task.getTaskUid());
                    this.consumer.unsubscribe();
                    LOGGER.info("Task {} - closing rebalance handling consumer", (Object)this.task.getTaskUid());
                    this.consumer.close();
                    LOGGER.info("Task {} - finished closing rebalance handling consumer", (Object)this.task.getTaskUid());
                    return;
                }
                catch (InterruptException e) {
                    LOGGER.error("Task Uid {} caught exception when interrupting RebalancingEventListener", (Object)this.task.getTaskUid(), (Object)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }, "SpannerConnector-RebalancingEventListener");
        this.thread.setUncaughtExceptionHandler((t, ex) -> this.errorHandler.accept(new SpannerConnectorException("Error during poll from the Rebalance Topic", ex)));
        LOGGER.info("Task {} - starting rebalancing event listener", (Object)this.task.getTaskUid());
        this.thread.start();
    }

    private boolean isLeader(Collection<TopicPartition> partitions) {
        return partitions.stream().anyMatch(x -> x.partition() == 0);
    }

    public void shutdown() {
        LOGGER.info("Task {} - shutting down rebalancing event listener", (Object)this.task.getTaskUid());
        this.resettableDelayedAction.clear();
        if (this.thread == null) {
            return;
        }
        this.thread.interrupt();
        while (!this.thread.getState().equals((Object)Thread.State.TERMINATED)) {
            LOGGER.info("Task {} - shutting down rebalancing event listener with state {}", (Object)this.task.getTaskUid(), (Object)this.thread.getState());
            this.thread.interrupt();
        }
        LOGGER.info("Task {} - finished shutting down rebalancing event listener", (Object)this.task.getTaskUid());
        this.thread = null;
    }
}

