/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task.operation;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.task.TaskStateUtil;
import io.debezium.connector.spanner.task.TaskSyncContext;
import io.debezium.connector.spanner.task.operation.Operation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorEndDetectionOperation
implements Operation {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectorEndDetectionOperation.class);
    private final Runnable finishingWorkHandler;
    private final Timestamp endTime;
    private boolean isRequiredPublishSyncEvent = false;

    public ConnectorEndDetectionOperation(Runnable finishingWorkHandler, Timestamp endTime) {
        this.finishingWorkHandler = finishingWorkHandler;
        this.endTime = endTime;
    }

    @Override
    public boolean isRequiredPublishSyncEvent() {
        return this.isRequiredPublishSyncEvent;
    }

    @Override
    public TaskSyncContext doOperation(TaskSyncContext taskSyncContext) {
        if (this.endTime == null || taskSyncContext.isFinished()) {
            return taskSyncContext;
        }
        if (Timestamp.now().toSqlTimestamp().after(this.endTime.toSqlTimestamp()) && TaskStateUtil.totalInProgressPartitions(taskSyncContext) == 0 && TaskStateUtil.totalFinishedPartitions(taskSyncContext) > 0) {
            this.finishingWorkHandler.run();
            LOGGER.info("Connector finished work, end time reached");
            this.isRequiredPublishSyncEvent = true;
            return taskSyncContext.toBuilder().finished(true).build();
        }
        return taskSyncContext;
    }
}

