/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.latency;

import com.datadoghq.sketch.ddsketch.DDSketch;
import com.datadoghq.sketch.ddsketch.DDSketches;
import io.debezium.connector.spanner.task.utils.TimeoutMeter;
import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.ArrayUtils;

public class QuantileMeter {
    private static final int QUEUE_SIZE = 1000;
    private static final double[] QUANTILES = new double[]{0.5, 0.95, 0.99};
    private static final Double[] EMPTY_VALUES = new Double[]{null, null, null};
    private final BlockingQueue<Double> queue = new LinkedBlockingQueue<Double>(1000);
    private final Thread thread;
    private final DDSketch sketch = DDSketches.unboundedDense((double)0.01);
    private final Consumer<Throwable> errorConsumer;

    public QuantileMeter(Duration clearInterval, Consumer<Throwable> errorConsumer) {
        this.errorConsumer = errorConsumer;
        this.thread = new Thread(() -> {
            TimeoutMeter timeoutMeter = null;
            if (!clearInterval.isZero()) {
                timeoutMeter = TimeoutMeter.setTimeout(clearInterval);
            }
            while (!Thread.currentThread().isInterrupted()) {
                Double pollValue;
                try {
                    pollValue = this.queue.poll(100L, TimeUnit.MILLISECONDS);
                    if (timeoutMeter != null && timeoutMeter.isExpired()) {
                        timeoutMeter = TimeoutMeter.setTimeout(clearInterval);
                        this.sketch.clear();
                    }
                    if (pollValue == null) {
                        continue;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                this.accept(pollValue);
            }
        }, "SpannerConnector-QuantileMeter");
        this.thread.setUncaughtExceptionHandler((t, ex) -> this.errorConsumer.accept(ex));
    }

    public void start() {
        this.thread.start();
    }

    public boolean addValue(double value) {
        return this.queue.offer(value);
    }

    private synchronized void accept(double value) {
        this.sketch.accept(value);
    }

    public synchronized Double getValueAtQuantile(double quantile) {
        return this.sketch.isEmpty() ? null : Double.valueOf(this.sketch.getValueAtQuantile(quantile));
    }

    public synchronized Double[] getValuesAtQuantiles() {
        return this.sketch.isEmpty() ? EMPTY_VALUES : ArrayUtils.toObject((double[])this.sketch.getValuesAtQuantiles(QUANTILES));
    }

    public synchronized void reset() {
        this.queue.clear();
        this.sketch.clear();
    }

    public void shutdown() {
        this.reset();
        this.thread.interrupt();
    }

    double getCount() {
        return this.sketch.getCount();
    }
}

