/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.kafka;

import io.debezium.connector.spanner.kafka.KafkaUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeTopicsResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaPartitionInfoProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaPartitionInfoProvider.class);
    private final AdminClient adminClient;

    public KafkaPartitionInfoProvider(AdminClient adminClient) {
        this.adminClient = adminClient;
    }

    public Collection<Integer> getPartitions(String topicName, Optional<Integer> numPartitions) throws ExecutionException, InterruptedException {
        try {
            if (!KafkaUtils.topicExists(this.adminClient, topicName)) {
                KafkaUtils.createTopic(this.adminClient, topicName, numPartitions, Map.of());
            }
            DescribeTopicsResult result = this.adminClient.describeTopics(Collections.singletonList(topicName));
            KafkaFuture topicDescription = (KafkaFuture)result.topicNameValues().get(topicName);
            return ((TopicDescription)topicDescription.get()).partitions().stream().map(TopicPartitionInfo::partition).collect(Collectors.toSet());
        }
        catch (ExecutionException ex) {
            LOGGER.error("Cannot get partitions for topic: {}. {}", (Object)topicName, (Object)ex.getMessage());
            if (ex.getCause() instanceof UnknownTopicOrPartitionException) {
                return Set.of();
            }
            throw ex;
        }
    }
}

