/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.task;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.SpannerConnectorConfig;
import io.debezium.connector.spanner.kafka.internal.model.MessageTypeEnum;
import io.debezium.connector.spanner.kafka.internal.model.PartitionState;
import io.debezium.connector.spanner.kafka.internal.model.PartitionStateEnum;
import io.debezium.connector.spanner.kafka.internal.model.RebalanceState;
import io.debezium.connector.spanner.kafka.internal.model.TaskState;
import io.debezium.connector.spanner.kafka.internal.model.TaskSyncEvent;
import io.debezium.connector.spanner.task.EpochOffsetHolder;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskSyncContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskSyncContext.class);
    private final String taskUid;
    private final RebalanceState rebalanceState;
    private final String consumerId;
    private final long rebalanceGenerationId;
    private final EpochOffsetHolder epochOffsetHolder;
    private final long currentKafkaRecordOffset;
    private final boolean isLeader;
    private final long createdTimestamp;
    private final Map<String, TaskState> taskStates;
    private final TaskState currentTaskState;
    private final Timestamp databaseSchemaTimestamp;
    private final boolean finished;
    private final boolean initialized;

    public Map<String, TaskState> getAllTaskStates() {
        HashMap<String, TaskState> taskStateMap = new HashMap<String, TaskState>(this.taskStates);
        taskStateMap.put(this.currentTaskState.getTaskUid(), this.currentTaskState.toBuilder().consumerId(this.consumerId).rebalanceGenerationId(this.rebalanceGenerationId).stateTimestamp(Instant.now().toEpochMilli()).build());
        return Map.copyOf(taskStateMap);
    }

    public TaskSyncEvent buildTaskSyncEvent() {
        return this.buildTaskSyncEvent(MessageTypeEnum.REGULAR);
    }

    public TaskSyncEvent buildTaskSyncEvent(MessageTypeEnum messageType) {
        return TaskSyncEvent.builder().epochOffset(this.epochOffsetHolder.getEpochOffset()).taskStates(this.getAllTaskStates()).taskUid(this.getTaskUid()).consumerId(this.getConsumerId()).rebalanceGenerationId(this.getRebalanceGenerationId()).messageTimestamp(this.getCreatedTimestamp()).messageType(messageType).databaseSchemaTimestamp(this.databaseSchemaTimestamp).build();
    }

    public static TaskSyncContext getInitialContext(String taskUid, SpannerConnectorConfig connectorConfig) {
        long now = Instant.now().toEpochMilli();
        return TaskSyncContext.builder().taskUid(taskUid).consumerId("").databaseSchemaTimestamp(connectorConfig.startTime()).rebalanceGenerationId(-2L).rebalanceState(RebalanceState.START_INITIAL_SYNC).createdTimestamp(now).currentTaskState(TaskState.builder().taskUid(taskUid).consumerId("").partitions(Collections.emptyList()).sharedPartitions(Collections.emptyList()).stateTimestamp(now).build()).build();
    }

    private static EpochOffsetHolder defaultEpochOffsetHolder() {
        return new EpochOffsetHolder(0L);
    }

    private static boolean defaultIsLeader() {
        return false;
    }

    private static long defaultCreatedTimestamp() {
        return Instant.now().toEpochMilli();
    }

    private static Map<String, TaskState> defaultTaskStates() {
        return Map.of();
    }

    TaskSyncContext(String taskUid, RebalanceState rebalanceState, String consumerId, long rebalanceGenerationId, EpochOffsetHolder epochOffsetHolder, long currentKafkaRecordOffset, boolean isLeader, long createdTimestamp, Map<String, TaskState> taskStates, TaskState currentTaskState, Timestamp databaseSchemaTimestamp, boolean finished, boolean initialized) {
        this.taskUid = taskUid;
        this.rebalanceState = rebalanceState;
        this.consumerId = consumerId;
        this.rebalanceGenerationId = rebalanceGenerationId;
        this.epochOffsetHolder = epochOffsetHolder;
        this.currentKafkaRecordOffset = currentKafkaRecordOffset;
        this.isLeader = isLeader;
        this.createdTimestamp = createdTimestamp;
        this.taskStates = taskStates;
        this.currentTaskState = currentTaskState;
        this.databaseSchemaTimestamp = databaseSchemaTimestamp;
        this.finished = finished;
        this.initialized = initialized;
    }

    public static TaskSyncContextBuilder builder() {
        return new TaskSyncContextBuilder();
    }

    public TaskSyncContextBuilder toBuilder() {
        return new TaskSyncContextBuilder().taskUid(this.taskUid).rebalanceState(this.rebalanceState).consumerId(this.consumerId).rebalanceGenerationId(this.rebalanceGenerationId).epochOffsetHolder(this.epochOffsetHolder).currentKafkaRecordOffset(this.currentKafkaRecordOffset).isLeader(this.isLeader).createdTimestamp(this.createdTimestamp).taskStates(this.taskStates).currentTaskState(this.currentTaskState).databaseSchemaTimestamp(this.databaseSchemaTimestamp).finished(this.finished).initialized(this.initialized);
    }

    public String getTaskUid() {
        return this.taskUid;
    }

    public RebalanceState getRebalanceState() {
        return this.rebalanceState;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public long getRebalanceGenerationId() {
        return this.rebalanceGenerationId;
    }

    public EpochOffsetHolder getEpochOffsetHolder() {
        return this.epochOffsetHolder;
    }

    public long getCurrentKafkaRecordOffset() {
        return this.currentKafkaRecordOffset;
    }

    public boolean isLeader() {
        return this.isLeader;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public Map<String, TaskState> getTaskStates() {
        return this.taskStates;
    }

    public TaskState getCurrentTaskState() {
        return this.currentTaskState;
    }

    public Timestamp getDatabaseSchemaTimestamp() {
        return this.databaseSchemaTimestamp;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean checkDuplication(boolean printOffsets, String loggingString) {
        Map<String, List<PartitionState>> partitionsMap = this.getAllTaskStates().values().stream().flatMap(taskState -> taskState.getPartitions().stream()).filter(partitionState -> !partitionState.getState().equals((Object)PartitionStateEnum.FINISHED) && !partitionState.getState().equals((Object)PartitionStateEnum.REMOVED)).collect(Collectors.groupingBy(PartitionState::getToken));
        int numPartitions = partitionsMap.size();
        Set<String> duplicatesInPartitions = this.checkDuplicationInMap(partitionsMap);
        if (!duplicatesInPartitions.isEmpty()) {
            if (printOffsets) {
                LOGGER.warn("task: {}, logging {}, taskSyncContext: found duplication in partitionsMap with size {}: {}, {}", new Object[]{this.getTaskUid(), loggingString, numPartitions, duplicatesInPartitions, this.getAllTaskStates()});
            }
            return true;
        }
        Map<String, PartitionState> partitions = partitionsMap.entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<String, PartitionState>((String)entry.getKey(), (PartitionState)((List)entry.getValue()).get(0))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, List<PartitionState>> sharedPartitionsMap = this.getAllTaskStates().values().stream().flatMap(taskState -> taskState.getSharedPartitions().stream()).filter(partitionState -> !partitions.containsKey(partitionState.getToken())).collect(Collectors.groupingBy(PartitionState::getToken));
        int numSharedPartitions = sharedPartitionsMap.size();
        Set<String> duplicatesInSharedPartitions = this.checkDuplicationInMap(sharedPartitionsMap);
        if (!duplicatesInSharedPartitions.isEmpty()) {
            if (printOffsets) {
                LOGGER.warn("task: {}, logging {}, taskSyncContext: found duplication in sharedPartitionsMap with size {}: {}, {}", new Object[]{this.getTaskUid(), loggingString, numSharedPartitions, duplicatesInSharedPartitions, this.getAllTaskStates()});
            }
            return true;
        }
        if (printOffsets) {
            LOGGER.warn("task: {}, logging {}, taskSyncContext: counted num partitions {} and num shared partitions {} ", new Object[]{this.getTaskUid(), loggingString, numPartitions, numSharedPartitions});
        }
        return false;
    }

    public String toString() {
        return "TaskSyncContext(taskUid=" + this.getTaskUid() + ", rebalanceState=" + this.getRebalanceState() + ", consumerId=" + this.getConsumerId() + ", rebalanceGenerationId=" + this.getRebalanceGenerationId() + ", epochOffsetHolder=" + this.getEpochOffsetHolder() + ", currentKafkaRecordOffset=" + this.getCurrentKafkaRecordOffset() + ", isLeader=" + this.isLeader() + ", createdTimestamp=" + this.getCreatedTimestamp() + ", taskStates=" + this.getTaskStates() + ", currentTaskState=" + this.getCurrentTaskState() + ")";
    }

    private Set<String> checkDuplicationInMap(Map<String, List<PartitionState>> map) {
        return map.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toUnmodifiableSet());
    }

    public static class TaskSyncContextBuilder {
        private String taskUid;
        private RebalanceState rebalanceState;
        private String consumerId;
        private long rebalanceGenerationId;
        private boolean epochOffsetHolderSet;
        private EpochOffsetHolder epochOffsetHolderValue;
        private long currentKafkaRecordOffset;
        private boolean isLeaderSet;
        private boolean isLeaderValue;
        private boolean createdTimestampSet;
        private long createdTimestampValue;
        private boolean taskStatesSet;
        private Map<String, TaskState> taskStatesValue;
        private TaskState currentTaskState;
        private Timestamp databaseSchemaTimestamp;
        private boolean finished;
        private boolean initialized;

        TaskSyncContextBuilder() {
        }

        public TaskSyncContextBuilder taskUid(String taskUid) {
            this.taskUid = taskUid;
            return this;
        }

        public TaskSyncContextBuilder rebalanceState(RebalanceState rebalanceState) {
            this.rebalanceState = rebalanceState;
            return this;
        }

        public TaskSyncContextBuilder consumerId(String consumerId) {
            this.consumerId = consumerId;
            return this;
        }

        public TaskSyncContextBuilder rebalanceGenerationId(long rebalanceGenerationId) {
            this.rebalanceGenerationId = rebalanceGenerationId;
            return this;
        }

        public TaskSyncContextBuilder epochOffsetHolder(EpochOffsetHolder epochOffsetHolder) {
            this.epochOffsetHolderValue = epochOffsetHolder;
            this.epochOffsetHolderSet = true;
            return this;
        }

        public TaskSyncContextBuilder currentKafkaRecordOffset(long currentKafkaRecordOffset) {
            this.currentKafkaRecordOffset = currentKafkaRecordOffset;
            return this;
        }

        public TaskSyncContextBuilder isLeader(boolean isLeader) {
            this.isLeaderValue = isLeader;
            this.isLeaderSet = true;
            return this;
        }

        public TaskSyncContextBuilder createdTimestamp(long createdTimestamp) {
            this.createdTimestampValue = createdTimestamp;
            this.createdTimestampSet = true;
            return this;
        }

        public TaskSyncContextBuilder taskStates(Map<String, TaskState> taskStates) {
            this.taskStatesValue = taskStates;
            this.taskStatesSet = true;
            return this;
        }

        public TaskSyncContextBuilder currentTaskState(TaskState currentTaskState) {
            this.currentTaskState = currentTaskState;
            return this;
        }

        public TaskSyncContextBuilder databaseSchemaTimestamp(Timestamp databaseSchemaTimestamp) {
            this.databaseSchemaTimestamp = databaseSchemaTimestamp;
            return this;
        }

        public TaskSyncContextBuilder finished(boolean finished) {
            this.finished = finished;
            return this;
        }

        public TaskSyncContextBuilder initialized(boolean initialized) {
            this.initialized = initialized;
            return this;
        }

        public TaskSyncContext build() {
            EpochOffsetHolder epochOffsetHolderValue = this.epochOffsetHolderValue;
            if (!this.epochOffsetHolderSet) {
                epochOffsetHolderValue = TaskSyncContext.defaultEpochOffsetHolder();
            }
            boolean isLeaderValue = this.isLeaderValue;
            if (!this.isLeaderSet) {
                isLeaderValue = TaskSyncContext.defaultIsLeader();
            }
            long createdTimestampValue = this.createdTimestampValue;
            if (!this.createdTimestampSet) {
                createdTimestampValue = TaskSyncContext.defaultCreatedTimestamp();
            }
            Map<String, TaskState> taskStatesValue = this.taskStatesValue;
            if (!this.taskStatesSet) {
                taskStatesValue = TaskSyncContext.defaultTaskStates();
            }
            return new TaskSyncContext(this.taskUid, this.rebalanceState, this.consumerId, this.rebalanceGenerationId, epochOffsetHolderValue, this.currentKafkaRecordOffset, isLeaderValue, createdTimestampValue, taskStatesValue, this.currentTaskState, this.databaseSchemaTimestamp, this.finished, this.initialized);
        }

        public String toString() {
            return "TaskSyncContext.TaskSyncContextBuilder(taskUid=" + this.taskUid + ", rebalanceState=" + this.rebalanceState + ", consumerId=" + this.consumerId + ", rebalanceGenerationId=" + this.rebalanceGenerationId + ", epochOffsetHolder=" + this.epochOffsetHolderValue + ", currentKafkaRecordOffset=" + this.currentKafkaRecordOffset + ", isLeader=" + this.isLeaderValue + ", createdTimestamp=" + this.createdTimestampValue + ", taskStates=" + this.taskStatesValue + ", currentTaskState=" + this.currentTaskState + ")";
        }
    }
}

