/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.metrics.latency;

import com.google.cloud.Timestamp;
import io.debezium.connector.spanner.processor.SourceRecordUtils;
import java.time.Instant;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public class LatencyCalculator {
    private LatencyCalculator() {
    }

    public static Long getTotalLatency(SourceRecord record) {
        Struct source = LatencyCalculator.getSource(record);
        if (source == null) {
            return null;
        }
        long commitTimestamp = source.getInt64("ts_ms");
        long pollAtTimestamp = SourceRecordUtils.extractPollTimestamp(record);
        return pollAtTimestamp - commitTimestamp;
    }

    public static Long getReadToEmitLatency(SourceRecord record) {
        Struct source = LatencyCalculator.getSource(record);
        if (source == null) {
            return null;
        }
        Long readAtTimestamp = source.getInt64("read_at_timestamp");
        if (readAtTimestamp == null) {
            return null;
        }
        long pollAtTimestamp = SourceRecordUtils.extractPollTimestamp(record);
        return pollAtTimestamp - readAtTimestamp;
    }

    public static Long getSpannerLatency(SourceRecord record) {
        Struct source = LatencyCalculator.getSource(record);
        if (source == null) {
            return null;
        }
        Long readAtTimestamp = source.getInt64("read_at_timestamp");
        if (readAtTimestamp == null) {
            return null;
        }
        long commitTimestamp = source.getInt64("ts_ms");
        return readAtTimestamp - commitTimestamp;
    }

    public static Long getCommitToEmitLatency(SourceRecord record) {
        Struct source = LatencyCalculator.getSource(record);
        if (source == null) {
            return null;
        }
        long commitTimestamp = source.getInt64("ts_ms");
        Long emitAtTimestamp = SourceRecordUtils.extractEmitTimestamp(record);
        if (emitAtTimestamp == null) {
            return null;
        }
        return emitAtTimestamp - commitTimestamp;
    }

    public static Long getTimeBehindLowWatermark(Timestamp lowWatermark) {
        return Instant.now().toEpochMilli() - lowWatermark.toSqlTimestamp().toInstant().toEpochMilli();
    }

    public static Long getCommitToPublishLatency(SourceRecord record) {
        Struct source = LatencyCalculator.getSource(record);
        Long publishAtTimestamp = SourceRecordUtils.extractPublishTimestamp(record);
        if (source == null || publishAtTimestamp == null) {
            return null;
        }
        long commitAtTimestamp = source.getInt64("ts_ms");
        return publishAtTimestamp - commitAtTimestamp;
    }

    public static Long getEmitToPublishLatency(SourceRecord record) {
        Struct source = LatencyCalculator.getSource(record);
        Long publishAtTimestamp = SourceRecordUtils.extractPublishTimestamp(record);
        if (source == null || publishAtTimestamp == null) {
            return null;
        }
        Long emitAtTimestamp = SourceRecordUtils.extractEmitTimestamp(record);
        if (emitAtTimestamp == null) {
            return null;
        }
        return publishAtTimestamp - emitAtTimestamp;
    }

    public static Long getOwnConnectorLatency(SourceRecord record) {
        Struct source = LatencyCalculator.getSource(record);
        if (source == null) {
            return null;
        }
        Long readAtTimestamp = source.getInt64("read_at_timestamp");
        if (readAtTimestamp == null) {
            return null;
        }
        Long emitAtTimestamp = SourceRecordUtils.extractEmitTimestamp(record);
        if (emitAtTimestamp == null) {
            return null;
        }
        return emitAtTimestamp - readAtTimestamp;
    }

    public static Long getLowWatermarkLag(SourceRecord record) {
        Struct source = LatencyCalculator.getSource(record);
        if (source == null) {
            return null;
        }
        Long lowWatermark = source.getInt64("low_watermark");
        if (lowWatermark != null) {
            return Instant.now().toEpochMilli() - lowWatermark;
        }
        return null;
    }

    private static Struct getSource(SourceRecord record) {
        Object value = record.value();
        if (value instanceof Struct) {
            Struct struct = (Struct)value;
            if (struct.schema().field("source") == null) {
                return null;
            }
            return struct.getStruct("source");
        }
        return null;
    }
}

