/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner.db.model.schema;

import io.debezium.connector.spanner.db.model.schema.ColumnType;
import io.debezium.connector.spanner.db.model.schema.DataType;

public class Column {
    private final String name;
    private final ColumnType type;
    private final boolean primaryKey;
    private final long ordinalPosition;
    private final Boolean nullable;

    public Column(String name, ColumnType type, boolean primaryKey, long ordinalPosition, Boolean nullable) {
        this.name = name;
        this.type = type;
        this.primaryKey = primaryKey;
        this.ordinalPosition = ordinalPosition;
        this.nullable = nullable;
    }

    public String getName() {
        return this.name;
    }

    public ColumnType getType() {
        return this.type;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public long getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public static Column create(String name, String spannerType, boolean primaryKey, long ordinalPosition, boolean nullable) {
        return new Column(name, Column.parseColumnType(spannerType), primaryKey, ordinalPosition, nullable);
    }

    private static ColumnType parseColumnType(String spannerType) {
        if ("BOOL".equals(spannerType = spannerType.toUpperCase())) {
            return new ColumnType(DataType.BOOL);
        }
        if ("INT64".equals(spannerType)) {
            return new ColumnType(DataType.INT64);
        }
        if ("FLOAT64".equals(spannerType)) {
            return new ColumnType(DataType.FLOAT64);
        }
        if (spannerType.startsWith("STRING")) {
            return new ColumnType(DataType.STRING);
        }
        if (spannerType.startsWith("BYTES")) {
            return new ColumnType(DataType.BYTES);
        }
        if ("TIMESTAMP".equals(spannerType)) {
            return new ColumnType(DataType.TIMESTAMP);
        }
        if ("DATE".equals(spannerType)) {
            return new ColumnType(DataType.DATE);
        }
        if ("NUMERIC".equals(spannerType)) {
            return new ColumnType(DataType.NUMERIC);
        }
        if ("JSON".equals(spannerType)) {
            return new ColumnType(DataType.JSON);
        }
        if (spannerType.startsWith("ARRAY")) {
            String spannerArrayType = spannerType.substring(6, spannerType.length() - 1);
            ColumnType itemType = Column.parseColumnType(spannerArrayType);
            return new ColumnType(DataType.ARRAY, itemType);
        }
        throw new IllegalArgumentException("Unknown spanner type " + spannerType);
    }
}

