/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.spanner;

import io.debezium.function.BlockingConsumer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinishingPartitionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(FinishingPartitionManager.class);
    private final BlockingConsumer<String> finishedPartitionConsumer;
    private final Map<String, String> lastEmittedRecord = new ConcurrentHashMap<String, String>();
    private final Map<String, Boolean> partitionPendingFinish = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, String> lastCommittedRecord = new ConcurrentHashMap<String, String>();

    public FinishingPartitionManager(BlockingConsumer<String> finishedPartitionConsumer) {
        this.finishedPartitionConsumer = finishedPartitionConsumer;
    }

    public void newRecord(String token, String recordUid) {
        this.lastEmittedRecord.put(token, recordUid);
    }

    public void registerPartition(String token) {
        this.partitionPendingFinish.put(token, false);
    }

    public void commitRecord(String token, String recordUid) throws InterruptedException {
        Boolean pendingFinishFlag = this.partitionPendingFinish.get(token);
        if (pendingFinishFlag == null) {
            LOGGER.warn("Partition has not been registered to finish or already finished {}", (Object)token);
            return;
        }
        if (!pendingFinishFlag.booleanValue()) {
            this.lastCommittedRecord.put(token, recordUid);
            return;
        }
        if (this.lastEmittedRecord.get(token) == null || this.lastEmittedRecord.get(token).equals(recordUid)) {
            LOGGER.info("Finished forcing the token to be finished {}", (Object)token);
            this.forceFinish(token);
        }
    }

    public void onPartitionFinishEvent(String token) throws InterruptedException {
        LOGGER.info("onPartitionFinishEvent: {}", (Object)token);
        Boolean pendingFinishFlag = this.partitionPendingFinish.get(token);
        if (pendingFinishFlag == null) {
            LOGGER.warn("Partition has not been registered to finish or already finished {}", (Object)token);
            return;
        }
        if (this.lastEmittedRecord.get(token) == null || this.lastEmittedRecord.get(token).equals(this.lastCommittedRecord.get(token))) {
            LOGGER.info("Forcing the token to be finished {}", (Object)token);
            this.forceFinish(token);
            LOGGER.info("Finished forcing the token to be finished {}", (Object)token);
        } else {
            this.partitionPendingFinish.put(token, true);
        }
    }

    public void forceFinish(String token) throws InterruptedException {
        this.finishedPartitionConsumer.accept((Object)token);
        this.partitionPendingFinish.remove(token);
        this.lastEmittedRecord.remove(token);
        this.lastCommittedRecord.remove(token);
    }

    public Set<String> getPendingFinishPartitions() {
        return this.partitionPendingFinish.entrySet().stream().filter(entry -> Boolean.TRUE.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }
}

