/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.connection.ReplicationMessage;
import java.time.Instant;
import java.util.List;
import java.util.OptionalLong;

public class TransactionMessage
implements ReplicationMessage {
    private final long transactionId;
    private final Instant commitTime;
    private final ReplicationMessage.Operation operation;

    public TransactionMessage(ReplicationMessage.Operation operation, long transactionId, Instant commitTime) {
        this.operation = operation;
        this.transactionId = transactionId;
        this.commitTime = commitTime;
    }

    @Override
    public boolean isLastEventForLsn() {
        return this.operation == ReplicationMessage.Operation.COMMIT;
    }

    @Override
    public OptionalLong getTransactionId() {
        return OptionalLong.of(this.transactionId);
    }

    @Override
    public String getTable() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        return this.operation;
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Instant getCommitTime() {
        return this.commitTime;
    }

    public String toString() {
        return "TransactionMessage [transactionId=" + this.transactionId + ", commitTime=" + String.valueOf(this.commitTime) + ", operation=" + String.valueOf((Object)this.operation) + "]";
    }
}

