/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection.pgproto;

import io.debezium.DebeziumException;
import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.UnchangedToastedReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.AbstractReplicationMessageColumn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.connector.postgresql.connection.ReplicationMessageColumnValueResolver;
import io.debezium.connector.postgresql.connection.pgproto.PgProtoColumnValue;
import io.debezium.connector.postgresql.proto.PgProto;
import io.debezium.util.Strings;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

class PgProtoReplicationMessage
implements ReplicationMessage {
    private final PgProto.RowMessage rawMessage;
    private final TypeRegistry typeRegistry;

    PgProtoReplicationMessage(PgProto.RowMessage rawMessage, TypeRegistry typeRegistry) {
        this.rawMessage = rawMessage;
        this.typeRegistry = typeRegistry;
        if (this.missingTypeMetadata()) {
            throw new DebeziumException("Protobuf message does not contain metadata. Unsupported version of protobuf plug-in is deployed in the database.");
        }
    }

    @Override
    public ReplicationMessage.Operation getOperation() {
        switch (this.rawMessage.getOp()) {
            case INSERT: {
                return ReplicationMessage.Operation.INSERT;
            }
            case UPDATE: {
                return ReplicationMessage.Operation.UPDATE;
            }
            case DELETE: {
                return ReplicationMessage.Operation.DELETE;
            }
            case BEGIN: {
                return ReplicationMessage.Operation.BEGIN;
            }
            case COMMIT: {
                return ReplicationMessage.Operation.COMMIT;
            }
        }
        throw new IllegalArgumentException("Unknown operation '" + String.valueOf((Object)this.rawMessage.getOp()) + "' in replication stream message");
    }

    @Override
    public Instant getCommitTime() {
        return Instant.ofEpochSecond(0L, this.rawMessage.getCommitTime() * 1000L);
    }

    @Override
    public OptionalLong getTransactionId() {
        return OptionalLong.of(Integer.toUnsignedLong(this.rawMessage.getTransactionId()));
    }

    @Override
    public String getTable() {
        return this.rawMessage.getTable();
    }

    @Override
    public List<ReplicationMessage.Column> getOldTupleList() {
        return this.transform(this.rawMessage.getOldTupleList(), null);
    }

    @Override
    public List<ReplicationMessage.Column> getNewTupleList() {
        return this.transform(this.rawMessage.getNewTupleList(), this.rawMessage.getNewTypeinfoList());
    }

    private boolean missingTypeMetadata() {
        if (this.rawMessage.getOp() == PgProto.Op.BEGIN || this.rawMessage.getOp() == PgProto.Op.COMMIT || this.rawMessage.getOp() == PgProto.Op.DELETE) {
            return false;
        }
        return this.rawMessage.getNewTypeinfoList() == null;
    }

    private List<ReplicationMessage.Column> transform(List<PgProto.DatumMessage> messageList, List<PgProto.TypeInfo> typeInfoList) {
        return IntStream.range(0, messageList.size()).mapToObj(index -> {
            final PgProto.DatumMessage datum = (PgProto.DatumMessage)messageList.get(index);
            Optional<Object> typeInfo = Optional.ofNullable(typeInfoList != null ? (PgProto.TypeInfo)typeInfoList.get(index) : null);
            final String columnName = Strings.unquoteIdentifierPart((String)datum.getColumnName());
            final PostgresType type = this.typeRegistry.get((int)datum.getColumnType());
            if (datum.hasDatumMissing()) {
                return new UnchangedToastedReplicationMessageColumn(columnName, type, typeInfo.map(PgProto.TypeInfo::getModifier).orElse(null), typeInfo.map(PgProto.TypeInfo::getValueOptional).orElse(Boolean.FALSE));
            }
            final String fullType = typeInfo.map(PgProto.TypeInfo::getModifier).orElse(null);
            return new AbstractReplicationMessageColumn(columnName, type, fullType, typeInfo.map(PgProto.TypeInfo::getValueOptional).orElse(Boolean.FALSE)){

                @Override
                public Object getValue(PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
                    return PgProtoReplicationMessage.this.getValue(columnName, type, fullType, datum, connection, includeUnknownDatatypes);
                }

                public String toString() {
                    return datum.toString();
                }
            };
        }).collect(Collectors.toList());
    }

    @Override
    public boolean isLastEventForLsn() {
        return true;
    }

    public Object getValue(String columnName, PostgresType type, String fullType, PgProto.DatumMessage datumMessage, PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        PgProtoColumnValue columnValue = new PgProtoColumnValue(datumMessage);
        return ReplicationMessageColumnValueResolver.resolveValue(columnName, type, fullType, columnValue, connection, includeUnknownDatatypes, this.typeRegistry);
    }

    public String toString() {
        return "PgProtoReplicationMessage [rawMessage=" + String.valueOf(this.rawMessage) + "]";
    }
}

