/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.DebeziumException;
import io.debezium.connector.postgresql.connection.Lsn;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalPositionLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WalPositionLocator.class);
    private final Lsn lastCommitStoredLsn;
    private final Lsn lastEventStoredLsn;
    private final ReplicationMessage.Operation lastProcessedMessageType;
    private Lsn txStartLsn = null;
    private Lsn lsnAfterLastEventStoredLsn = null;
    private Lsn firstLsnReceived = null;
    private boolean passMessages = true;
    private Lsn startStreamingLsn = null;
    private boolean storeLsnAfterLastEventStoredLsn = false;
    private Set<Lsn> lsnSeen = new HashSet<Lsn>(1000);

    public WalPositionLocator(Lsn lastCommitStoredLsn, Lsn lastEventStoredLsn, ReplicationMessage.Operation lastProcessedMessageType) {
        this.lastCommitStoredLsn = lastCommitStoredLsn;
        this.lastEventStoredLsn = lastEventStoredLsn;
        this.lastProcessedMessageType = lastProcessedMessageType;
        LOGGER.info("Looking for WAL restart position for last commit LSN '{}' and last change LSN '{}'", (Object)lastCommitStoredLsn, (Object)lastEventStoredLsn);
    }

    public WalPositionLocator() {
        this.lastCommitStoredLsn = null;
        this.lastEventStoredLsn = null;
        this.lastProcessedMessageType = null;
        LOGGER.info("WAL position will not be searched");
    }

    public Optional<Lsn> resumeFromLsn(Lsn currentLsn, ReplicationMessage message) {
        LOGGER.trace("Processing LSN '{}', operation '{}'", (Object)currentLsn, (Object)message.getOperation());
        this.lsnSeen.add(currentLsn);
        if (this.firstLsnReceived == null) {
            this.firstLsnReceived = currentLsn;
            LOGGER.info("First LSN '{}' received", (Object)this.firstLsnReceived);
        }
        if (this.storeLsnAfterLastEventStoredLsn) {
            if (currentLsn.equals(this.lastEventStoredLsn)) {
                if (this.txStartLsn != null && (this.lastProcessedMessageType == null || this.lastProcessedMessageType == ReplicationMessage.Operation.BEGIN || this.lastProcessedMessageType == ReplicationMessage.Operation.COMMIT)) {
                    LOGGER.info("Will restart from LSN '{}' corresponding to the event following the BEGIN event", (Object)this.txStartLsn);
                    this.startStreamingLsn = this.txStartLsn;
                    return Optional.of(this.startStreamingLsn);
                }
                return Optional.empty();
            }
            this.lsnAfterLastEventStoredLsn = currentLsn;
            this.storeLsnAfterLastEventStoredLsn = false;
            LOGGER.info("LSN after last stored change LSN '{}' received", (Object)this.lsnAfterLastEventStoredLsn);
            this.startStreamingLsn = this.lsnAfterLastEventStoredLsn;
            return Optional.of(this.startStreamingLsn);
        }
        if (currentLsn.equals(this.lastEventStoredLsn)) {
            this.storeLsnAfterLastEventStoredLsn = true;
        }
        if (this.lastCommitStoredLsn == null) {
            this.startStreamingLsn = this.firstLsnReceived;
            return Optional.of(this.startStreamingLsn);
        }
        switch (message.getOperation()) {
            case BEGIN: {
                this.txStartLsn = currentLsn;
                break;
            }
            case COMMIT: {
                if (currentLsn.compareTo(this.lastCommitStoredLsn) <= 0) break;
                LOGGER.info("Received COMMIT LSN '{}' larger than than last stored commit LSN '{}'", (Object)currentLsn, (Object)this.lastCommitStoredLsn);
                if (this.lsnAfterLastEventStoredLsn != null) {
                    this.startStreamingLsn = this.lsnAfterLastEventStoredLsn;
                    LOGGER.info("Will restart from LSN '{}' that follows the lastest stored", (Object)this.startStreamingLsn);
                    return Optional.of(this.startStreamingLsn);
                }
                if (this.txStartLsn != null) {
                    this.startStreamingLsn = this.txStartLsn;
                    LOGGER.info("Will restart from LSN '{}' that is start of the first unprocessed transaction", (Object)this.startStreamingLsn);
                    return Optional.of(this.startStreamingLsn);
                }
                this.startStreamingLsn = this.firstLsnReceived;
                LOGGER.info("Will restart from LSN '{}' that is the first LSN available", (Object)this.startStreamingLsn);
                return Optional.of(this.startStreamingLsn);
            }
        }
        return Optional.empty();
    }

    public boolean skipMessage(Lsn lsn) {
        if (this.passMessages) {
            return false;
        }
        if (this.startStreamingLsn == null || this.startStreamingLsn.equals(lsn)) {
            LOGGER.info("Message with LSN '{}' arrived, switching off the filtering", (Object)lsn);
            this.passMessages = true;
            this.lsnSeen = new HashSet<Lsn>();
            return false;
        }
        if (lsn.isValid() && !this.lsnSeen.contains(lsn)) {
            throw new DebeziumException(String.format("Message with LSN '%s' not present among LSNs seen in the location phase '%s'. This is unexpected and can lead to an infinite loop or a data loss.", lsn, this.lsnSeen));
        }
        LOGGER.debug("Message with LSN '{}' filtered", (Object)lsn);
        return true;
    }

    public void enableFiltering() {
        this.passMessages = false;
    }

    public boolean searchingEnabled() {
        return this.lastEventStoredLsn != null;
    }

    public Lsn getLastEventStoredLsn() {
        return this.lastEventStoredLsn;
    }

    public Lsn getLastCommitStoredLsn() {
        return this.lastCommitStoredLsn;
    }

    public String toString() {
        return "WalPositionLocator [lastCommitStoredLsn=" + String.valueOf(this.lastCommitStoredLsn) + ", lastEventStoredLsn=" + String.valueOf(this.lastEventStoredLsn) + ", lastProcessedMessageType=" + String.valueOf((Object)this.lastProcessedMessageType) + ", txStartLsn=" + String.valueOf(this.txStartLsn) + ", lsnAfterLastEventStoredLsn=" + String.valueOf(this.lsnAfterLastEventStoredLsn) + ", firstLsnReceived=" + String.valueOf(this.firstLsnReceived) + ", passMessages=" + this.passMessages + ", startStreamingLsn=" + String.valueOf(this.startStreamingLsn) + ", storeLsnAfterLastEventStoredLsn=" + this.storeLsnAfterLastEventStoredLsn + "]";
    }
}

