/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.UnchangedToastedReplicationMessageColumn;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class UnchangedToastedPlaceholder {
    private final Map<Object, Object> placeholderValues = new HashMap<Object, Object>();
    private final byte[] toastPlaceholderBinary;
    private final String toastPlaceholderString;
    private final Map<String, String> toastPlaceholderHstore = new HashMap<String, String>();
    private final String toastPlaceholderUuid;

    public UnchangedToastedPlaceholder(PostgresConnectorConfig connectorConfig) {
        this.toastPlaceholderBinary = connectorConfig.getUnavailableValuePlaceholder();
        this.toastPlaceholderString = new String(this.toastPlaceholderBinary);
        this.toastPlaceholderUuid = UUID.nameUUIDFromBytes(this.toastPlaceholderBinary).toString();
        this.placeholderValues.put(UnchangedToastedReplicationMessageColumn.UNCHANGED_TOAST_VALUE, this.toastPlaceholderString);
        this.placeholderValues.put(UnchangedToastedReplicationMessageColumn.UNCHANGED_TEXT_ARRAY_TOAST_VALUE, Arrays.asList(this.toastPlaceholderString));
        this.placeholderValues.put(UnchangedToastedReplicationMessageColumn.UNCHANGED_BINARY_ARRAY_TOAST_VALUE, Arrays.asList(new byte[][]{this.toastPlaceholderBinary}));
        ArrayList<Integer> toastedIntArrayPlaceholder = new ArrayList<Integer>(this.toastPlaceholderBinary.length);
        ArrayList<Long> toastedLongArrayPlaceholder = new ArrayList<Long>(this.toastPlaceholderBinary.length);
        for (byte b : this.toastPlaceholderBinary) {
            toastedIntArrayPlaceholder.add(Integer.valueOf(b));
            toastedLongArrayPlaceholder.add(Long.valueOf(b));
        }
        this.placeholderValues.put(UnchangedToastedReplicationMessageColumn.UNCHANGED_INT_ARRAY_TOAST_VALUE, toastedIntArrayPlaceholder);
        this.placeholderValues.put(UnchangedToastedReplicationMessageColumn.UNCHANGED_BIGINT_ARRAY_TOAST_VALUE, toastedLongArrayPlaceholder);
        this.toastPlaceholderHstore.put(this.toastPlaceholderString, this.toastPlaceholderString);
        this.placeholderValues.put(UnchangedToastedReplicationMessageColumn.UNCHANGED_HSTORE_TOAST_VALUE, this.toastPlaceholderHstore);
        this.placeholderValues.put(UnchangedToastedReplicationMessageColumn.UNCHANGED_UUID_TOAST_VALUE, Arrays.asList(this.toastPlaceholderUuid));
    }

    public Optional<Object> getValue(Object obj) {
        return Optional.ofNullable(this.placeholderValues.get(obj));
    }

    public byte[] getToastPlaceholderBinary() {
        return this.toastPlaceholderBinary;
    }

    public String getToastPlaceholderString() {
        return this.toastPlaceholderString;
    }
}

