/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.data.Ltree;
import io.debezium.connector.postgresql.data.vector.HalfVector;
import io.debezium.connector.postgresql.data.vector.SparseVector;
import io.debezium.connector.postgresql.data.vector.Vector;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class PostgresSchemaFactory
extends SchemaFactory {
    private static final PostgresSchemaFactory postgresSchemaFactoryObject = new PostgresSchemaFactory();
    public static final String POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_VALUE_SCHEMA_NAME = "io.debezium.connector.postgresql.MessageValue";
    private static final int POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_VALUE_SCHEMA_VERSION = 1;
    private static final String POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_KEY_SCHEMA_NAME = "io.debezium.connector.postgresql.MessageKey";
    private static final int POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_KEY_SCHEMA_VERSION = 1;
    private static final String POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_BLOCK_SCHEMA_NAME = "io.debezium.connector.postgresql.Message";
    private static final int POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_BLOCK_SCHEMA_VERSION = 1;

    public static PostgresSchemaFactory get() {
        return postgresSchemaFactoryObject;
    }

    public Schema logicalDecodingMessageMonitorKeySchema(SchemaNameAdjuster adjuster) {
        return SchemaBuilder.struct().name(adjuster.adjust(POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_KEY_SCHEMA_NAME)).version(Integer.valueOf(1)).field("prefix", Schema.OPTIONAL_STRING_SCHEMA).build();
    }

    public Schema logicalDecodingMessageMonitorBlockSchema(SchemaNameAdjuster adjuster, CommonConnectorConfig.BinaryHandlingMode binaryHandlingMode) {
        return SchemaBuilder.struct().name(adjuster.adjust(POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_BLOCK_SCHEMA_NAME)).version(Integer.valueOf(1)).field("prefix", Schema.OPTIONAL_STRING_SCHEMA).field("content", binaryHandlingMode.getSchema().optional().build()).build();
    }

    public Schema logicalDecodingMessageMonitorValueSchema(SchemaNameAdjuster adjuster, PostgresConnectorConfig config, CommonConnectorConfig.BinaryHandlingMode binaryHandlingMode) {
        return SchemaBuilder.struct().name(adjuster.adjust(POSTGRES_LOGICAL_DECODING_MESSAGE_MONITOR_VALUE_SCHEMA_NAME)).version(Integer.valueOf(1)).field("op", Schema.STRING_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT64_SCHEMA).field("source", config.getSourceInfoStructMaker().schema()).field("message", this.logicalDecodingMessageMonitorBlockSchema(adjuster, binaryHandlingMode)).build();
    }

    public SchemaBuilder datatypeLtreeSchema() {
        return SchemaBuilder.string().name("io.debezium.data.Ltree").version(Integer.valueOf(Ltree.SCHEMA_VERSION));
    }

    public SchemaBuilder datatypeVectorSchema() {
        return SchemaBuilder.array((Schema)Schema.FLOAT64_SCHEMA).name("io.debezium.data.Vector").version(Integer.valueOf(Vector.SCHEMA_VERSION));
    }

    public SchemaBuilder datatypeHalfVectorSchema() {
        return SchemaBuilder.array((Schema)Schema.FLOAT32_SCHEMA).name("io.debezium.data.HalfVector").version(Integer.valueOf(HalfVector.SCHEMA_VERSION));
    }

    public SchemaBuilder datatypeSparseVectorSchema() {
        return SchemaBuilder.struct().name("io.debezium.data.SparseVector").name("io.debezium.data.SparseVector").version(Integer.valueOf(SparseVector.SCHEMA_VERSION)).doc("Sparse vector").field("dimensions", Schema.INT16_SCHEMA).field("vector", SchemaBuilder.map((Schema)Schema.INT16_SCHEMA, (Schema)Schema.FLOAT64_SCHEMA).build());
    }
}

