/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.snapshot.mode;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.Map;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NeverSnapshotter
implements Snapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NeverSnapshotter.class);

    public String name() {
        return PostgresConnectorConfig.SnapshotMode.NEVER.getValue();
    }

    public void configure(Map<String, ?> properties) {
    }

    public void validate(boolean offsetContextExists, boolean isSnapshotInProgress) {
        if (offsetContextExists && isSnapshotInProgress) {
            String msg = "The connector previously stopped while taking a snapshot, but now the connector is configured to never allow snapshots. Reconfigure the connector to use snapshots initially or when needed.";
            LOGGER.error(msg);
            throw new ConnectException(msg);
        }
        LOGGER.info("Snapshots are not allowed as per configuration, starting streaming logical changes only");
    }

    public boolean shouldStream() {
        return true;
    }

    public boolean shouldSnapshot() {
        return false;
    }

    public boolean shouldSnapshotOnSchemaError() {
        return false;
    }

    public boolean shouldSnapshotOnDataError() {
        return false;
    }

    public boolean shouldSnapshotSchema() {
        return false;
    }
}

