/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.snapshot.mode;

import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialSnapshotter
implements Snapshotter {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitialSnapshotter.class);
    protected boolean offsetContextExists;
    protected boolean isSnapshotInProgress;

    public String name() {
        return PostgresConnectorConfig.SnapshotMode.INITIAL.getValue();
    }

    public void configure(Map<String, ?> properties) {
    }

    public void validate(boolean offsetContextExists, boolean isSnapshotInProgress) {
        this.offsetContextExists = offsetContextExists;
        this.isSnapshotInProgress = isSnapshotInProgress;
    }

    public boolean shouldStream() {
        return true;
    }

    public boolean shouldSnapshot() {
        if (!this.offsetContextExists) {
            LOGGER.info("Taking initial snapshot for new datasource");
            return true;
        }
        if (this.isSnapshotInProgress) {
            LOGGER.info("Found previous incomplete snapshot");
            return true;
        }
        LOGGER.info("Previous snapshot has completed successfully, streaming logical changes from last known position");
        return false;
    }

    public boolean shouldSnapshotOnSchemaError() {
        return false;
    }

    public boolean shouldSnapshotOnDataError() {
        return false;
    }

    public boolean shouldSnapshotSchema() {
        return false;
    }
}

