/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.snapshot;

import io.debezium.DebeziumException;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.bean.spi.BeanRegistryAware;
import io.debezium.config.Configuration;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.service.spi.ServiceProvider;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.spi.SnapshotQuery;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class SnapshotQueryProvider
implements ServiceProvider<SnapshotQuery> {
    public SnapshotQuery createService(Configuration configuration, ServiceRegistry serviceRegistry) {
        BeanRegistry beanRegistry = (BeanRegistry)serviceRegistry.tryGetService(BeanRegistry.class);
        PostgresConnectorConfig postgresConnectorConfig = (PostgresConnectorConfig)((Object)beanRegistry.lookupByName("ConnectorConfig", PostgresConnectorConfig.class));
        PostgresConnectorConfig.SnapshotQueryMode configuredSnapshotQueryMode = postgresConnectorConfig.snapshotQueryMode();
        String snapshotQueryModeCustomName = postgresConnectorConfig.snapshotQueryModeCustomName();
        String snapshotQueryMode = PostgresConnectorConfig.SnapshotQueryMode.CUSTOM.equals((Object)configuredSnapshotQueryMode) && !snapshotQueryModeCustomName.isEmpty() ? snapshotQueryModeCustomName : configuredSnapshotQueryMode.getValue();
        Optional<SnapshotQuery> snapshotQuery = StreamSupport.stream(ServiceLoader.load(SnapshotQuery.class).spliterator(), false).filter(s -> s.name().equals(snapshotQueryMode)).findAny();
        return snapshotQuery.map(s -> {
            s.configure(configuration.asMap());
            if (s instanceof BeanRegistryAware) {
                ((BeanRegistryAware)s).injectBeanRegistry(beanRegistry);
            }
            return s;
        }).orElseThrow(() -> new DebeziumException(String.format("Unable to find %s snapshot query mode. Please check your configuration.", snapshotQueryMode)));
    }

    public Class<SnapshotQuery> getServiceClass() {
        return SnapshotQuery.class;
    }
}

