/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.util.HexConverter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class PostgisGeometry {
    private static final String HEXEWKB_EMPTY_GEOMETRYCOLLECTION = "010700000000000000";
    private final byte[] wkb;
    private final Integer srid;

    public static PostgisGeometry fromHexEwkb(String hexEwkb) {
        byte[] ewkb = HexConverter.convertFromHex((String)hexEwkb);
        return PostgisGeometry.fromEwkb(ewkb);
    }

    public static PostgisGeometry fromEwkb(byte[] ewkb) {
        return new PostgisGeometry(ewkb, PostgisGeometry.parseSrid(ewkb));
    }

    public static PostgisGeometry createEmpty() {
        return PostgisGeometry.fromHexEwkb(HEXEWKB_EMPTY_GEOMETRYCOLLECTION);
    }

    private PostgisGeometry(byte[] ewkb, Integer srid) {
        this.wkb = ewkb;
        this.srid = srid;
    }

    public byte[] getWkb() {
        return this.wkb;
    }

    public Integer getSrid() {
        return this.srid;
    }

    private static Integer parseSrid(byte[] ewkb) {
        ByteBuffer reader;
        if (ewkb.length < 9) {
            throw new IllegalArgumentException("Invalid EWKB length");
        }
        reader.order((reader = ByteBuffer.wrap(ewkb)).get() != 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
        int geomType = reader.getInt();
        int EWKB_SRID = 0x20000000;
        if ((geomType & 0x20000000) != 0) {
            return reader.getInt();
        }
        return null;
    }
}

