/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.config.Field;
import io.debezium.connector.postgresql.connection.MessageDecoder;
import io.debezium.connector.postgresql.connection.pgproto.PgProtoMessageDecoder;
import io.debezium.connector.postgresql.connection.wal2json.NonStreamingWal2JsonMessageDecoder;
import io.debezium.connector.postgresql.connection.wal2json.StreamingWal2JsonMessageDecoder;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.TableId;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;

public class PostgresConnectorConfig
extends RelationalDatabaseConnectorConfig {
    protected static final String DATABASE_CONFIG_PREFIX = "database.";
    protected static final int DEFAULT_PORT = 5432;
    protected static final int DEFAULT_ROWS_FETCH_SIZE = 10240;
    protected static final long DEFAULT_SNAPSHOT_LOCK_TIMEOUT_MILLIS = TimeUnit.SECONDS.toMillis(10L);
    private static final String TABLE_WHITELIST_NAME = "table.whitelist";
    public static final Field PLUGIN_NAME = Field.create((String)"plugin.name").withDisplayName("Plugin").withEnum(LogicalDecoder.class, (Enum)LogicalDecoder.DECODERBUFS).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The name of the Postgres logical decoding plugin installed on the server. Supported values are '" + LogicalDecoder.DECODERBUFS.getValue() + "' and '" + LogicalDecoder.WAL2JSON.getValue() + "'. Defaults to '" + LogicalDecoder.DECODERBUFS.getValue() + "'.");
    public static final Field SLOT_NAME = Field.create((String)"slot.name").withDisplayName("Slot").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDefault("debezium").withDescription("The name of the Postgres logical decoding slot created for streaming changes from a plugin.Defaults to 'debezium");
    public static final Field DROP_SLOT_ON_STOP = Field.create((String)"slot.drop_on_stop").withDisplayName("Drop slot on stop").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether or not to drop the logical replication slot when the connector finishes orderlyBy default the replication is kept so that on restart progress can resume from the last recorded location");
    public static final Field HOSTNAME = Field.create((String)("database." + JdbcConfiguration.HOSTNAME)).withDisplayName("Hostname").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Resolvable hostname or IP address of the Postgres database server.");
    public static final Field PORT = Field.create((String)("database." + JdbcConfiguration.PORT)).withDisplayName("Port").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withDefault(5432).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isInteger}).withDescription("Port of the Postgres database server.");
    public static final Field USER = Field.create((String)("database." + JdbcConfiguration.USER)).withDisplayName("User").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("Name of the Postgres database user to be used when connecting to the database.");
    public static final Field PASSWORD = Field.create((String)("database." + JdbcConfiguration.PASSWORD)).withDisplayName("Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.HIGH).withDescription("Password of the Postgres database user to be used when connecting to the database.");
    public static final Field DATABASE_NAME = Field.create((String)("database." + JdbcConfiguration.DATABASE)).withDisplayName("Database").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isRequired}).withDescription("The name of the database the connector should be monitoring");
    public static final Field ON_CONNECT_STATEMENTS = Field.create((String)("database." + JdbcConfiguration.ON_CONNECT_STATEMENTS)).withDisplayName("Initial statements").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.LOW).withDescription("A semicolon separated list of SQL statements to be executed when a JDBC connection to the database is established. Note that the connector may establish JDBC connections at its own discretion, so this should typically be used for configurationof session parameters only, but not for executing DML statements. Use doubled semicolon (';;') to use a semicolon as a character and not as a delimiter.");
    public static final Field SERVER_NAME = Field.create((String)"database.server.name").withDisplayName("Namespace").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.HIGH).withDescription("Unique name that identifies the database server and all recorded offsets, andthat is used as a prefix for all schemas and topics. Each distinct Postgres installation should have a separate namespace and monitored by at most one Debezium connector. Defaults to 'host:port/database'");
    public static final Field TOPIC_SELECTION_STRATEGY = Field.create((String)"topic.selection.strategy").withDisplayName("Topic selection strategy").withEnum(TopicSelectionStrategy.class, (Enum)TopicSelectionStrategy.TOPIC_PER_TABLE).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("How events received from the DB should be placed on topics. Options include'table' (the default) each DB table will have a separate Kafka topic; 'schema' there will be one Kafka topic per DB schema; events from multiple topics belonging to the same schema will be placed on the same topic");
    public static final Field ROWS_FETCH_SIZE = Field.create((String)"rows.fetch.size").withDisplayName("Result set fetch size").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The maximum number of DB rows that should be loaded into memory while performing a snapshot").withDefault(10240).withValidation(new Field.Validator[]{Field::isPositiveLong});
    public static final Field SSL_MODE = Field.create((String)"database.sslmode").withDisplayName("SSL mode").withEnum(SecureConnectionMode.class, (Enum)SecureConnectionMode.DISABLED).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether to use an encrypted connection to Postgres. Options include'disable' (the default) to use an unencrypted connection; 'require' to use a secure (encrypted) connection, and fail if one cannot be established; 'verify-ca' like 'required' but additionally verify the server TLS certificate against the configured Certificate Authority (CA) certificates, or fail if no valid matching CA certificates are found; or'verify-full' like 'verify-ca' but additionally verify that the server certificate matches the host to which the connection is attempted.");
    public static final Field SSL_CLIENT_CERT = Field.create((String)"database.sslcert").withDisplayName("SSL Client Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL Certificate for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY = Field.create((String)"database.sslkey").withDisplayName("SSL Client Key").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the SSL private key for the client. See the Postgres SSL docs for further information");
    public static final Field SSL_CLIENT_KEY_PASSWORD = Field.create((String)"database.sslpassword").withDisplayName("SSL Client Key Password").withType(ConfigDef.Type.PASSWORD).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Password to access the client private key from the file specified by 'database.sslkey'. See the Postgres SSL docs for further information");
    public static final Field SSL_ROOT_CERT = Field.create((String)"database.sslrootcert").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("File containing the root certificate(s) against which the server is validated. See the Postgres JDBC SSL docs for further information");
    public static final Field SSL_SOCKET_FACTORY = Field.create((String)"database.sslfactory").withDisplayName("SSL Root Certificate").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("A name of class to that creates SSL Sockets. Use org.postgresql.ssl.NonValidatingFactory to disable SSL validation in development environments");
    public static final Field SCHEMA_WHITELIST = Field.create((String)"schema.whitelist").withDisplayName("Schemas").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withDependents(new String[]{"table.whitelist"}).withDescription("The schemas for which events should be captured");
    public static final Field SCHEMA_BLACKLIST = Field.create((String)"schema.blacklist").withDisplayName("Exclude Schemas").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{PostgresConnectorConfig::validateSchemaBlacklist}).withInvisibleRecommender().withDescription("");
    public static final Field TABLE_WHITELIST = Field.create((String)"table.whitelist").withDisplayName("Tables").withType(ConfigDef.Type.LIST).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.HIGH).withValidation(new Field.Validator[]{Field::isListOfRegex}).withDescription("The tables for which changes are to be captured");
    public static final Field TABLE_BLACKLIST = Field.create((String)"table.blacklist").withDisplayName("Exclude Tables").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withValidation(new Field.Validator[]{Field::isListOfRegex, PostgresConnectorConfig::validateTableBlacklist}).withInvisibleRecommender();
    public static final Field COLUMN_BLACKLIST = Field.create((String)"column.blacklist").withDisplayName("Exclude Columns").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription("");
    public static final Field INCLUDE_SCHEMA_CHANGES = Field.create((String)"include.schema.changes").withDisplayName("Include database schema changes").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Whether the connector should publish changes in the database schema to a Kafka topic with the same name as the database server name.The default is 'false' because atm this feature is not supported by Postgres logical decoding").withDefault(false);
    public static final Field SNAPSHOT_MODE = Field.create((String)"snapshot.mode").withDisplayName("Snapshot mode").withEnum(SnapshotMode.class, (Enum)SnapshotMode.INITIAL).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("The criteria for running a snapshot upon startup of the connector. Options include: 'always' to specify that the connector run a snapshot each time it starts up; 'initial' (the default) to specify the connector can run a snapshot only when no offsets are available for the logical server name; 'initial_only' same as 'initial' except the connector should stop after completing the snapshot and before it would normally start emitting changes; and'never' to specify the connector should never run a snapshot and that upon first startup the connector should read from the last position (LSN) recorded by the server");
    public static final Field SNAPSHOT_LOCK_TIMEOUT_MS = Field.create((String)"snapshot.lock.timeout.ms").withDisplayName("Snapshot lock timeout (ms)").withWidth(ConfigDef.Width.LONG).withType(ConfigDef.Type.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDefault(DEFAULT_SNAPSHOT_LOCK_TIMEOUT_MILLIS).withDescription("The maximum number of millis to wait for table locks at the beginning of a snapshot. If locks cannot be acquired in this time frame, the snapshot will be aborted. Defaults to 10 seconds");
    public static final Field TIME_PRECISION_MODE = Field.create((String)"time.precision.mode").withDisplayName("Time Precision").withEnum(TemporalPrecisionMode.class, (Enum)TemporalPrecisionMode.ADAPTIVE).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Time, date, and timestamps can be represented with different kinds of precisions, including:'adaptive' (the default) bases the precision of time, date, and timestamp values on the database column's precision; 'adaptive_time_microseconds' like 'adaptive' mode, but TIME fields always use microseconds precision;'connect' always represents time, date, and timestamp values using Kafka Connect's built-in representations for Time, Date, and Timestamp, which uses millisecond precision regardless of the database columns' precision .");
    public static final Field HSTORE_HANDLING_MODE = Field.create((String)"hstore.handling.mode").withDisplayName("HStore Handling").withEnum(HStoreHandlingMode.class, (Enum)HStoreHandlingMode.JSON).withWidth(ConfigDef.Width.MEDIUM).withImportance(ConfigDef.Importance.LOW).withDescription("Specify how HSTORE columns should be represented in change events, including:'json' represents values as json string'map' (default) represents values using java.util.Map");
    public static final Field STATUS_UPDATE_INTERVAL_MS = Field.create((String)"status.update.interval.ms").withDisplayName("Status update interval (ms)").withType(ConfigDef.Type.INT).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Frequency in milliseconds for sending replication connection status updates to the server. Defaults to 10 seconds (10000 ms).").withValidation(new Field.Validator[]{Field::isPositiveInteger});
    public static final Field TCP_KEEPALIVE = Field.create((String)"database.tcpKeepAlive").withDisplayName("TCP keep-alive probe").withType(ConfigDef.Type.BOOLEAN).withDefault(true).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Enable or disable TCP keep-alive probe to avoid dropping TCP connection").withValidation(new Field.Validator[]{Field::isBoolean});
    public static final Field INCLUDE_UNKNOWN_DATATYPES = Field.create((String)"include.unknown.datatypes").withDisplayName("Include unknown datatypes").withType(ConfigDef.Type.BOOLEAN).withDefault(false).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify whether the fields of data type not supported by Debezium should be processed:'false' (the default) omits the fields; 'true' converts the field into an implementation dependent binary representation.");
    public static final Field SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE = Field.create((String)"snapshot.select.statement.overrides").withDisplayName("List of tables where the default select statement used during snapshotting should be overridden.").withType(ConfigDef.Type.STRING).withWidth(ConfigDef.Width.LONG).withImportance(ConfigDef.Importance.MEDIUM).withDescription(" This property contains a comma-separated list of fully-qualified tables (DB_NAME.TABLE_NAME). Select statements for the individual tables are specified in further configuration properties, one for each table, identified by the id 'snapshot.select.statement.overrides.[DB_NAME].[TABLE_NAME]'. The value of those properties is the select statement to use when retrieving data from the specific table during snapshotting. A possible use case for large append-only tables is setting a specific point where to start (resume) snapshotting, in case a previous snapshotting was interrupted.");
    public static final Field SCHEMA_REFRESH_MODE = Field.create((String)"schema.refresh.mode").withDisplayName("Schema refresh mode").withEnum(SchemaRefreshMode.class, (Enum)SchemaRefreshMode.COLUMNS_DIFF).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDescription("Specify the conditions that trigger a refresh of the in-memory schema for a table. 'columns_diff' (the default) is the safest mode, ensuring the in-memory schema stays in-sync with the database table's schema at all times. 'columns_diff_exclude_unchanged_toast' instructs the connector to refresh the in-memory schema cache if there is a discrepancy between it and the schema derived from the incoming message, unless unchanged TOASTable data fully accounts for the discrepancy. This setting can improve connector performance significantly if there are frequently-updated tables that have TOASTed data that are rarely part of these updates. However, it is possible for the in-memory schema to become outdated if TOASTable columns are dropped from the table.");
    public static Field.Set ALL_FIELDS = Field.setOf((Field[])new Field[]{PLUGIN_NAME, SLOT_NAME, DROP_SLOT_ON_STOP, DATABASE_NAME, USER, PASSWORD, HOSTNAME, PORT, ON_CONNECT_STATEMENTS, SERVER_NAME, TOPIC_SELECTION_STRATEGY, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, CommonConnectorConfig.POLL_INTERVAL_MS, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX, SCHEMA_WHITELIST, SCHEMA_BLACKLIST, TABLE_WHITELIST, TABLE_BLACKLIST, COLUMN_BLACKLIST, SNAPSHOT_MODE, TIME_PRECISION_MODE, RelationalDatabaseConnectorConfig.DECIMAL_HANDLING_MODE, HSTORE_HANDLING_MODE, SSL_MODE, SSL_CLIENT_CERT, SSL_CLIENT_KEY_PASSWORD, SSL_ROOT_CERT, SSL_CLIENT_KEY, SNAPSHOT_LOCK_TIMEOUT_MS, ROWS_FETCH_SIZE, SSL_SOCKET_FACTORY, STATUS_UPDATE_INTERVAL_MS, TCP_KEEPALIVE, INCLUDE_UNKNOWN_DATATYPES, SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, SCHEMA_REFRESH_MODE, CommonConnectorConfig.TOMBSTONES_ON_DELETE});
    private final Configuration config;
    private final TemporalPrecisionMode temporalPrecisionMode;
    private final HStoreHandlingMode hStoreHandlingMode;
    private final SnapshotMode snapshotMode;
    private final SchemaRefreshMode schemaRefreshMode;

    protected PostgresConnectorConfig(Configuration config) {
        super(config, PostgresConnectorConfig.getLogicalName(config), null, null);
        HStoreHandlingMode hStoreHandlingMode;
        this.config = config;
        this.temporalPrecisionMode = TemporalPrecisionMode.parse((String)config.getString(TIME_PRECISION_MODE));
        String hstoreHandlingModeStr = config.getString(HSTORE_HANDLING_MODE);
        this.hStoreHandlingMode = hStoreHandlingMode = HStoreHandlingMode.parse(hstoreHandlingModeStr);
        this.snapshotMode = SnapshotMode.parse(config.getString(SNAPSHOT_MODE));
        this.schemaRefreshMode = SchemaRefreshMode.parse(config.getString(SCHEMA_REFRESH_MODE));
    }

    private static String getLogicalName(Configuration config) {
        String logicalName = config.getString(SERVER_NAME);
        if (logicalName == null) {
            logicalName = config.getString(HOSTNAME) + ":" + config.getInteger(PORT) + "/" + config.getString(DATABASE_NAME);
        }
        return logicalName;
    }

    protected String hostname() {
        return this.config.getString(HOSTNAME);
    }

    protected int port() {
        return this.config.getInteger(PORT);
    }

    protected String databaseName() {
        return this.config.getString(DATABASE_NAME);
    }

    protected LogicalDecoder plugin() {
        return LogicalDecoder.parse(this.config.getString(PLUGIN_NAME));
    }

    protected String slotName() {
        return this.config.getString(SLOT_NAME);
    }

    protected boolean dropSlotOnStop() {
        return this.config.getBoolean(DROP_SLOT_ON_STOP);
    }

    protected Integer statusUpdateIntervalMillis() {
        return this.config.getInteger(STATUS_UPDATE_INTERVAL_MS, null);
    }

    protected TemporalPrecisionMode temporalPrecisionMode() {
        return this.temporalPrecisionMode;
    }

    protected HStoreHandlingMode hStoreHandlingMode() {
        return this.hStoreHandlingMode;
    }

    protected boolean includeUnknownDatatypes() {
        return this.config.getBoolean(INCLUDE_UNKNOWN_DATATYPES);
    }

    public Configuration jdbcConfig() {
        return this.config.subset(DATABASE_CONFIG_PREFIX, true);
    }

    protected TopicSelectionStrategy topicSelectionStrategy() {
        return TopicSelectionStrategy.TOPIC_PER_TABLE;
    }

    protected Map<String, ConfigValue> validate() {
        return this.config.validate(ALL_FIELDS);
    }

    protected String schemaBlacklist() {
        return this.config.getString(SCHEMA_BLACKLIST);
    }

    protected String schemaWhitelist() {
        return this.config.getString(SCHEMA_WHITELIST);
    }

    protected String tableBlacklist() {
        return this.config.getString(TABLE_BLACKLIST);
    }

    protected String tableWhitelist() {
        return this.config.getString(TABLE_WHITELIST);
    }

    protected String columnBlacklist() {
        return this.config.getString(COLUMN_BLACKLIST);
    }

    protected int rowsFetchSize() {
        return this.config.getInteger(ROWS_FETCH_SIZE);
    }

    protected long snapshotLockTimeoutMillis() {
        return this.config.getLong(SNAPSHOT_LOCK_TIMEOUT_MS);
    }

    protected boolean snapshotNeverAllowed() {
        return SnapshotMode.NEVER == this.snapshotMode;
    }

    protected boolean alwaysTakeSnapshot() {
        return SnapshotMode.ALWAYS == this.snapshotMode;
    }

    protected boolean initialOnlySnapshot() {
        return SnapshotMode.INITIAL_ONLY == this.snapshotMode;
    }

    protected String snapshotSelectOverrides() {
        return this.config.getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE);
    }

    protected String snapshotSelectOverrideForTable(String table) {
        return this.config.getString(SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE + "." + table);
    }

    protected boolean skipRefreshSchemaOnMissingToastableData() {
        return SchemaRefreshMode.COLUMNS_DIFF_EXCLUDE_UNCHANGED_TOAST == this.schemaRefreshMode;
    }

    protected static ConfigDef configDef() {
        ConfigDef config = new ConfigDef();
        Field.group((ConfigDef)config, (String)"Postgres", (Field[])new Field[]{SLOT_NAME, PLUGIN_NAME, SERVER_NAME, DATABASE_NAME, HOSTNAME, PORT, USER, PASSWORD, ON_CONNECT_STATEMENTS, SSL_MODE, SSL_CLIENT_CERT, SSL_CLIENT_KEY_PASSWORD, SSL_ROOT_CERT, SSL_CLIENT_KEY, DROP_SLOT_ON_STOP, SSL_SOCKET_FACTORY, STATUS_UPDATE_INTERVAL_MS, TCP_KEEPALIVE});
        Field.group((ConfigDef)config, (String)"Events", (Field[])new Field[]{SCHEMA_WHITELIST, SCHEMA_BLACKLIST, TABLE_WHITELIST, TABLE_BLACKLIST, COLUMN_BLACKLIST, INCLUDE_UNKNOWN_DATATYPES, SNAPSHOT_SELECT_STATEMENT_OVERRIDES_BY_TABLE, CommonConnectorConfig.TOMBSTONES_ON_DELETE, Heartbeat.HEARTBEAT_INTERVAL, Heartbeat.HEARTBEAT_TOPICS_PREFIX});
        Field.group((ConfigDef)config, (String)"Connector", (Field[])new Field[]{TOPIC_SELECTION_STRATEGY, CommonConnectorConfig.POLL_INTERVAL_MS, CommonConnectorConfig.MAX_BATCH_SIZE, CommonConnectorConfig.MAX_QUEUE_SIZE, SNAPSHOT_MODE, SNAPSHOT_LOCK_TIMEOUT_MS, TIME_PRECISION_MODE, RelationalDatabaseConnectorConfig.DECIMAL_HANDLING_MODE, HSTORE_HANDLING_MODE, SCHEMA_REFRESH_MODE, ROWS_FETCH_SIZE});
        return config;
    }

    private static int validateSchemaBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(SCHEMA_WHITELIST);
        String blacklist = config.getString(SCHEMA_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(SCHEMA_BLACKLIST, (Object)blacklist, "Schema whitelist is already specified");
            return 1;
        }
        return 0;
    }

    private static int validateTableBlacklist(Configuration config, Field field, Field.ValidationOutput problems) {
        String whitelist = config.getString(TABLE_WHITELIST);
        String blacklist = config.getString(TABLE_BLACKLIST);
        if (whitelist != null && blacklist != null) {
            problems.accept(TABLE_BLACKLIST, (Object)blacklist, "Table whitelist is already specified");
            return 1;
        }
        return 0;
    }

    public static enum SchemaRefreshMode implements EnumeratedValue
    {
        COLUMNS_DIFF("columns_diff"),
        COLUMNS_DIFF_EXCLUDE_UNCHANGED_TOAST("columns_diff_exclude_unchanged_toast");

        private final String value;

        private SchemaRefreshMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SchemaRefreshMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SchemaRefreshMode option : SchemaRefreshMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum LogicalDecoder implements EnumeratedValue
    {
        DECODERBUFS("decoderbufs"){

            @Override
            public MessageDecoder messageDecoder() {
                return new PgProtoMessageDecoder();
            }

            @Override
            public String getPostgresPluginName() {
                return this.getValue();
            }
        }
        ,
        WAL2JSON_STREAMING("wal2json_streaming"){

            @Override
            public MessageDecoder messageDecoder() {
                return new StreamingWal2JsonMessageDecoder();
            }

            @Override
            public String getPostgresPluginName() {
                return "wal2json";
            }
        }
        ,
        WAL2JSON_RDS_STREAMING("wal2json_rds_streaming"){

            @Override
            public MessageDecoder messageDecoder() {
                return new StreamingWal2JsonMessageDecoder();
            }

            @Override
            public boolean forceRds() {
                return true;
            }

            @Override
            public String getPostgresPluginName() {
                return "wal2json";
            }
        }
        ,
        WAL2JSON("wal2json"){

            @Override
            public MessageDecoder messageDecoder() {
                return new NonStreamingWal2JsonMessageDecoder();
            }

            @Override
            public String getPostgresPluginName() {
                return "wal2json";
            }
        }
        ,
        WAL2JSON_RDS("wal2json_rds"){

            @Override
            public MessageDecoder messageDecoder() {
                return new NonStreamingWal2JsonMessageDecoder();
            }

            @Override
            public boolean forceRds() {
                return true;
            }

            @Override
            public String getPostgresPluginName() {
                return "wal2json";
            }
        };

        private final String decoderName;

        private LogicalDecoder(String decoderName) {
            this.decoderName = decoderName;
        }

        public abstract MessageDecoder messageDecoder();

        public boolean forceRds() {
            return false;
        }

        public static LogicalDecoder parse(String s) {
            return LogicalDecoder.valueOf(s.trim().toUpperCase());
        }

        public String getValue() {
            return this.decoderName;
        }

        public abstract String getPostgresPluginName();
    }

    public static enum TopicSelectionStrategy implements EnumeratedValue
    {
        TOPIC_PER_TABLE("topic_per_table"){

            @Override
            public String getTopicName(TableId tableId, String prefix, String delimiter) {
                return String.join((CharSequence)delimiter, prefix, tableId.schema(), tableId.table());
            }
        }
        ,
        TOPIC_PER_SCHEMA("topic_per_schema"){

            @Override
            public String getTopicName(TableId tableId, String prefix, String delimiter) {
                return String.join((CharSequence)delimiter, prefix, tableId.schema());
            }
        };

        private String value;

        public String getValue() {
            return this.value;
        }

        public abstract String getTopicName(TableId var1, String var2, String var3);

        private TopicSelectionStrategy(String value) {
            this.value = value;
        }

        public static TopicSelectionStrategy parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (TopicSelectionStrategy option : TopicSelectionStrategy.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }
    }

    public static enum SecureConnectionMode implements EnumeratedValue
    {
        DISABLED("disable"),
        REQUIRED("require"),
        VERIFY_CA("verify-ca"),
        VERIFY_FULL("verify-full");

        private final String value;

        private SecureConnectionMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SecureConnectionMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SecureConnectionMode option : SecureConnectionMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SecureConnectionMode parse(String value, String defaultValue) {
            SecureConnectionMode mode = SecureConnectionMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SecureConnectionMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum SnapshotMode implements EnumeratedValue
    {
        ALWAYS("always"),
        INITIAL("initial"),
        NEVER("never"),
        INITIAL_ONLY("initial_only");

        private final String value;

        private SnapshotMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SnapshotMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (SnapshotMode option : SnapshotMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static SnapshotMode parse(String value, String defaultValue) {
            SnapshotMode mode = SnapshotMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = SnapshotMode.parse(defaultValue);
            }
            return mode;
        }
    }

    public static enum HStoreHandlingMode implements EnumeratedValue
    {
        JSON("json"),
        MAP("map");

        private final String value;

        private HStoreHandlingMode(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static HStoreHandlingMode parse(String value) {
            if (value == null) {
                return null;
            }
            value = value.trim();
            for (HStoreHandlingMode option : HStoreHandlingMode.values()) {
                if (!option.getValue().equalsIgnoreCase(value)) continue;
                return option;
            }
            return null;
        }

        public static HStoreHandlingMode parse(String value, String defaultValue) {
            HStoreHandlingMode mode = HStoreHandlingMode.parse(value);
            if (mode == null && defaultValue != null) {
                mode = HStoreHandlingMode.parse(defaultValue);
            }
            return mode;
        }
    }
}

