/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.postgresql.ChangeEvent;
import io.debezium.connector.postgresql.Module;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresSchema;
import io.debezium.connector.postgresql.PostgresTaskContext;
import io.debezium.connector.postgresql.PostgresTopicSelector;
import io.debezium.connector.postgresql.RecordsProducer;
import io.debezium.connector.postgresql.RecordsSnapshotProducer;
import io.debezium.connector.postgresql.RecordsStreamProducer;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.function.BlockingConsumer;
import io.debezium.relational.TableId;
import io.debezium.schema.TopicSelector;
import io.debezium.util.LoggingContext;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresConnectorTask
extends BaseSourceTask {
    private static final String CONTEXT_NAME = "postgres-connector-task";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final AtomicBoolean running = new AtomicBoolean(false);
    private PostgresTaskContext taskContext;
    private RecordsProducer producer;
    private volatile long lastProcessedLsn;
    private ChangeEventQueue<ChangeEvent> changeEventQueue;

    public void start(Configuration config) {
        Charset databaseCharset;
        TypeRegistry typeRegistry;
        if (this.running.get()) {
            return;
        }
        PostgresConnectorConfig connectorConfig = new PostgresConnectorConfig(config);
        try (PostgresConnection connection = new PostgresConnection(connectorConfig.jdbcConfig());){
            typeRegistry = connection.getTypeRegistry();
            databaseCharset = connection.getDatabaseCharset();
        }
        TopicSelector<TableId> topicSelector = PostgresTopicSelector.create(connectorConfig);
        PostgresSchema schema = new PostgresSchema(connectorConfig, typeRegistry, databaseCharset, topicSelector);
        this.taskContext = new PostgresTaskContext(connectorConfig, schema, topicSelector);
        SourceInfo sourceInfo = new SourceInfo(connectorConfig.getLogicalName(), connectorConfig.databaseName());
        Map existingOffset = this.context.offsetStorageReader().offset(sourceInfo.partition());
        LoggingContext.PreviousContext previousContext = this.taskContext.configureLoggingContext(CONTEXT_NAME);
        try {
            try (PostgresConnection connection = this.taskContext.createConnection();){
                this.logger.info(connection.serverInfo().toString());
            }
            if (existingOffset == null) {
                this.logger.info("No previous offset found");
                if (connectorConfig.snapshotNeverAllowed()) {
                    this.logger.info("Snapshots are not allowed as per configuration, starting streaming logical changes only");
                    this.producer = new RecordsStreamProducer(this.taskContext, sourceInfo);
                } else {
                    this.createSnapshotProducer(this.taskContext, sourceInfo, connectorConfig.initialOnlySnapshot());
                }
            } else {
                sourceInfo.load(existingOffset);
                this.logger.info("Found previous offset {}", (Object)sourceInfo);
                if (sourceInfo.isSnapshotInEffect()) {
                    if (connectorConfig.snapshotNeverAllowed()) {
                        String msg = "The connector previously stopped while taking a snapshot, but now the connector is configured to never allow snapshots. Reconfigure the connector to use snapshots initially or when needed.";
                        throw new ConnectException(msg);
                    }
                    this.logger.info("Found previous incomplete snapshot");
                    this.createSnapshotProducer(this.taskContext, sourceInfo, connectorConfig.initialOnlySnapshot());
                } else if (connectorConfig.alwaysTakeSnapshot()) {
                    this.logger.info("Taking a new snapshot as per configuration");
                    this.producer = new RecordsSnapshotProducer(this.taskContext, sourceInfo, true);
                } else {
                    this.logger.info("Previous snapshot has completed successfully, streaming logical changes from last known position");
                    this.producer = new RecordsStreamProducer(this.taskContext, sourceInfo);
                }
            }
            this.changeEventQueue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.producer.start((BlockingConsumer<ChangeEvent>)((BlockingConsumer)arg_0 -> this.changeEventQueue.enqueue(arg_0)), arg_0 -> this.changeEventQueue.producerFailure(arg_0));
            this.running.compareAndSet(false, true);
        }
        catch (SQLException e) {
            throw new ConnectException((Throwable)e);
        }
        finally {
            previousContext.restore();
        }
    }

    private void createSnapshotProducer(PostgresTaskContext taskContext, SourceInfo sourceInfo, boolean initialOnlySnapshot) {
        if (initialOnlySnapshot) {
            this.logger.info("Taking only a snapshot of the DB without streaming any changes afterwards...");
            this.producer = new RecordsSnapshotProducer(taskContext, sourceInfo, false);
        } else {
            this.logger.info("Taking a new snapshot of the DB and streaming logical changes once the snapshot is finished...");
            this.producer = new RecordsSnapshotProducer(taskContext, sourceInfo, true);
        }
    }

    public void commit() throws InterruptedException {
        if (this.running.get()) {
            this.producer.commit(this.lastProcessedLsn);
        }
    }

    public List<SourceRecord> poll() throws InterruptedException {
        List events = this.changeEventQueue.poll();
        if (events.size() > 0) {
            for (int i = events.size() - 1; i >= 0; --i) {
                SourceRecord r = ((ChangeEvent)events.get(i)).getRecord();
                if (!((ChangeEvent)events.get(i)).isLastOfLsn()) continue;
                Map offset = r.sourceOffset();
                this.lastProcessedLsn = (Long)offset.get("lsn");
                break;
            }
        }
        return events.stream().map(ChangeEvent::getRecord).collect(Collectors.toList());
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.producer.stop();
        }
    }

    public String version() {
        return Module.version();
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return PostgresConnectorConfig.ALL_FIELDS;
    }
}

