/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.postgresql.Filters;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.SourceInfo;
import io.debezium.connector.postgresql.TypeRegistry;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ServerInfo;
import io.debezium.relational.RelationalDatabaseSchema;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.schema.TopicSelector;
import io.debezium.util.SchemaNameAdjuster;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PostgresSchema
extends RelationalDatabaseSchema {
    protected static final String PUBLIC_SCHEMA_NAME = "public";
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresSchema.class);
    private final Filters filters;
    private Map<String, Integer> typeInfo;
    private final TypeRegistry typeRegistry;

    protected PostgresSchema(PostgresConnectorConfig config, TypeRegistry typeRegistry, TopicSelector<TableId> topicSelector) {
        super((CommonConnectorConfig)config, topicSelector, new Filters(config).tableFilter(), new Filters(config).columnFilter(), PostgresSchema.getTableSchemaBuilder(config, typeRegistry), false);
        this.filters = new Filters(config);
        this.typeRegistry = typeRegistry;
    }

    private static TableSchemaBuilder getTableSchemaBuilder(PostgresConnectorConfig config, TypeRegistry typeRegistry) {
        PostgresValueConverter valueConverter = new PostgresValueConverter(config.decimalHandlingMode(), config.temporalPrecisionMode(), ZoneOffset.UTC, null, config.includeUnknownDatatypes(), typeRegistry);
        return new TableSchemaBuilder((ValueConverterProvider)valueConverter, SchemaNameAdjuster.create((Logger)LOGGER), SourceInfo.SCHEMA);
    }

    protected PostgresSchema refresh(PostgresConnection connection, boolean printReplicaIdentityInfo) throws SQLException {
        if (this.typeInfo == null) {
            this.typeInfo = connection.readTypeInfo();
        }
        connection.readSchema(this.tables(), null, null, this.filters.tableNameFilter(), null, true);
        if (printReplicaIdentityInfo) {
            this.tableIds().forEach(tableId -> this.printReplicaIdentityInfo(connection, (TableId)tableId));
        }
        this.refreshSchemas();
        return this;
    }

    private void printReplicaIdentityInfo(PostgresConnection connection, TableId tableId) {
        try {
            ServerInfo.ReplicaIdentity replicaIdentity = connection.readReplicaIdentityInfo(tableId);
            LOGGER.info("REPLICA IDENTITY for '{}' is '{}'; {}", new Object[]{tableId, replicaIdentity.toString(), replicaIdentity.description()});
        }
        catch (SQLException e) {
            LOGGER.warn("Cannot determine REPLICA IDENTITY info for '{}'", (Object)tableId);
        }
    }

    protected void refresh(PostgresConnection connection, TableId tableId) throws SQLException {
        Tables temp = new Tables();
        Tables.TableNameFilter tableNameFilter = Tables.filterFor(Predicate.isEqual(tableId));
        connection.readSchema(temp, null, null, tableNameFilter, null, true);
        assert (temp.size() == 1);
        this.tables().overwriteTable(temp.forTable(tableId));
        this.refreshSchema(tableId);
    }

    protected void refresh(Table table) {
        this.tables().overwriteTable(table);
        this.refreshSchema(table.id());
    }

    protected boolean isFilteredOut(TableId id) {
        return !this.filters.tableFilter().test(id);
    }

    protected void refreshSchemas() {
        this.clearSchemas();
        this.tableIds().forEach(this::refreshSchema);
    }

    private void refreshSchema(TableId id) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("refreshing DB schema for table '{}'", (Object)id);
        }
        Table table = this.tableFor(id);
        this.buildAndRegisterSchema(table);
    }

    protected static TableId parse(String table) {
        TableId tableId = TableId.parse((String)table, (boolean)false);
        if (tableId == null) {
            return null;
        }
        return tableId.schema() == null ? new TableId(tableId.catalog(), PUBLIC_SCHEMA_NAME, tableId.table()) : tableId;
    }

    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }
}

