/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.connection.ReplicationMessage;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.postgresql.core.Oid;
import org.postgresql.util.PSQLException;

public final class PgOid
extends Oid {
    public static final int JSONB_JDBC_OID = 1111;
    public static final int JSONB_OID = 3802;
    public static final int TSTZRANGE_OID = 3910;
    private static final Map<String, String> LONG_TYPE_NAMES = Collections.unmodifiableMap(PgOid.getLongTypeNames());

    private static Map<String, String> getLongTypeNames() {
        HashMap<String, String> longTypeNames = new HashMap<String, String>();
        longTypeNames.put("bigint", "int8");
        longTypeNames.put("bit varying", "varbit");
        longTypeNames.put("boolean", "bool");
        longTypeNames.put("character", "bpchar");
        longTypeNames.put("character varying", "varchar");
        longTypeNames.put("double precision", "float8");
        longTypeNames.put("integer", "int4");
        longTypeNames.put("real", "float4");
        longTypeNames.put("smallint", "int2");
        longTypeNames.put("timestamp without time zone", "timestamp");
        longTypeNames.put("timestamp with time zone", "timestamptz");
        longTypeNames.put("time without time zone", "time");
        longTypeNames.put("time with time zone", "timetz");
        return longTypeNames;
    }

    private PgOid() {
    }

    protected static int jdbcColumnToOid(Column column) {
        if (column.jdbcType() == 2003) {
            return column.componentType();
        }
        return PgOid.typeNameToOid(column.typeName());
    }

    public static int typeNameToOid(String typeName) {
        if (typeName.toUpperCase().equals("TSTZRANGE")) {
            return 3910;
        }
        if (typeName.toUpperCase().equals("SMALLSERIAL")) {
            return 21;
        }
        if (typeName.toUpperCase().equals("SERIAL")) {
            return 23;
        }
        if (typeName.toUpperCase().equals("BIGSERIAL")) {
            return 20;
        }
        if (typeName.toUpperCase().equals("JSONB")) {
            return 3802;
        }
        try {
            return Oid.valueOf((String)typeName);
        }
        catch (PSQLException e) {
            return 0;
        }
    }

    public static String normalizeTypeName(String typeName) {
        return LONG_TYPE_NAMES.getOrDefault(typeName, typeName);
    }

    public static void reconcileJdbcOidTypeConstraints(ReplicationMessage.ColumnTypeMetadata columnTypeMetadata, ColumnEditor columnEditor) {
        switch (columnTypeMetadata.getName()) {
            case "money": {
                columnEditor.scale(0);
                break;
            }
            case "timestamp": {
                columnEditor.length(29);
                columnEditor.scale(6);
                break;
            }
            case "time": {
                columnEditor.length(15);
                columnEditor.scale(6);
            }
        }
    }
}

