/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.connector.postgresql.PgOid;
import io.debezium.connector.postgresql.proto.PgProto;
import io.debezium.data.Bits;
import io.debezium.data.Json;
import io.debezium.data.Uuid;
import io.debezium.data.geometry.Point;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.time.MicroDuration;
import io.debezium.time.ZonedTime;
import io.debezium.time.ZonedTimestamp;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.connect.data.Decimal;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGInterval;
import org.postgresql.util.PGobject;

public class PostgresValueConverter
extends JdbcValueConverters {
    protected static final double DAYS_PER_MONTH_AVG = 30.4375;

    protected PostgresValueConverter(boolean adaptiveTimePrecision, ZoneOffset defaultOffset) {
        super(JdbcValueConverters.DecimalMode.PRECISE, adaptiveTimePrecision, defaultOffset, null);
    }

    public SchemaBuilder schemaBuilder(Column column) {
        int oidValue = PgOid.jdbcColumnToOid(column);
        switch (oidValue) {
            case 1560: 
            case 1561: 
            case 1562: {
                return column.length() > 1 ? Bits.builder((int)column.length()) : SchemaBuilder.bool();
            }
            case 1186: {
                return MicroDuration.builder();
            }
            case 1184: {
                return ZonedTimestamp.builder();
            }
            case 1266: {
                return ZonedTime.builder();
            }
            case 26: {
                return SchemaBuilder.int64();
            }
            case 114: 
            case 1111: {
                return Json.builder();
            }
            case 3910: {
                return SchemaBuilder.string();
            }
            case 2950: {
                return Uuid.builder();
            }
            case 600: {
                return Point.builder();
            }
            case 790: {
                return Decimal.builder((int)column.scale());
            }
        }
        return super.schemaBuilder(column);
    }

    public ValueConverter converter(Column column, Field fieldDefn) {
        int oidValue = PgOid.jdbcColumnToOid(column);
        switch (oidValue) {
            case 1560: 
            case 1562: {
                return this.convertBits(column, fieldDefn);
            }
            case 1186: {
                return data -> this.convertInterval(column, fieldDefn, data);
            }
            case 1184: {
                return data -> this.convertTimestampWithZone(column, fieldDefn, data);
            }
            case 1266: {
                return data -> this.convertTimeWithZone(column, fieldDefn, data);
            }
            case 26: {
                return data -> this.convertBigInt(column, fieldDefn, data);
            }
            case 114: 
            case 1111: 
            case 2950: 
            case 3910: {
                return data -> super.convertString(column, fieldDefn, data);
            }
            case 600: {
                return data -> this.convertPoint(column, fieldDefn, data);
            }
            case 790: {
                return data -> this.convertMoney(column, fieldDefn, data);
            }
        }
        return super.converter(column, fieldDefn);
    }

    protected Object convertBit(Column column, Field fieldDefn, Object data) {
        if (data instanceof String) {
            data = Integer.valueOf((String)data, 2);
        }
        return super.convertBit(column, fieldDefn, data);
    }

    protected Object convertBits(Column column, Field fieldDefn, Object data, int numBytes) {
        if (data instanceof PGobject) {
            data = ((PGobject)data).getValue();
        }
        if (data instanceof String) {
            long longValue = Long.parseLong((String)data, 2);
            data = -32768L <= longValue && longValue <= 32767L ? (Number)((short)longValue) : (Number)(Integer.MIN_VALUE <= longValue && longValue <= Integer.MAX_VALUE ? (Number)((int)longValue) : (Number)longValue);
        }
        return super.convertBits(column, fieldDefn, data, numBytes);
    }

    protected Object convertMoney(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return 0L;
        }
        if (data instanceof Double) {
            return BigDecimal.valueOf((Double)data);
        }
        if (data instanceof Number) {
            return BigDecimal.valueOf(((Number)data).longValue(), 2);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertInterval(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return Duration.ofMillis(0L);
        }
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        if (data instanceof PGInterval) {
            PGInterval interval = (PGInterval)data;
            return MicroDuration.durationMicros((int)interval.getYears(), (int)interval.getMonths(), (int)interval.getDays(), (int)interval.getHours(), (int)interval.getMinutes(), (double)interval.getSeconds(), (Double)30.4375);
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochMillis(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            data = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
        }
        return super.convertTimestampToEpochMillis(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochMicros(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            data = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
        }
        return super.convertTimestampToEpochMicros(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochNanos(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            data = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
        }
        return super.convertTimestampToEpochNanos(column, fieldDefn, data);
    }

    protected Object convertTimestampToEpochMillisAsDate(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            data = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
        }
        return super.convertTimestampToEpochMillisAsDate(column, fieldDefn, data);
    }

    protected Object convertTimestampWithZone(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            LocalDateTime localDateTime = PostgresValueConverter.nanosToLocalDateTimeUTC((Long)data);
            data = OffsetDateTime.of(localDateTime, ZoneOffset.UTC);
        } else if (data instanceof Date) {
            data = OffsetDateTime.ofInstant(Instant.ofEpochMilli(((Date)data).getTime()), ZoneOffset.UTC);
        }
        return super.convertTimestampWithZone(column, fieldDefn, data);
    }

    protected Object convertTimeWithZone(Column column, Field fieldDefn, Object data) {
        if (data instanceof Long) {
            LocalTime localTime = LocalTime.ofNanoOfDay((Long)data);
            data = OffsetTime.of(localTime, ZoneOffset.UTC);
        } else if (data instanceof Date) {
            data = OffsetTime.ofInstant(Instant.ofEpochMilli(((Date)data).getTime()), ZoneOffset.UTC);
        }
        return super.convertTimeWithZone(column, fieldDefn, data);
    }

    private static LocalDateTime nanosToLocalDateTimeUTC(long epocNanos) {
        BigInteger epochMicrosBigInt = BigInteger.valueOf(epocNanos);
        BigInteger[] secondsAndNanos = epochMicrosBigInt.divideAndRemainder(BigInteger.valueOf(TimeUnit.SECONDS.toNanos(1L)));
        return LocalDateTime.ofInstant(Instant.ofEpochSecond(secondsAndNanos[0].longValue(), secondsAndNanos[1].longValue()), ZoneOffset.UTC);
    }

    protected Object convertPoint(Column column, Field fieldDefn, Object data) {
        if (data == null) {
            data = fieldDefn.schema().defaultValue();
        }
        Schema schema = fieldDefn.schema();
        if (data == null) {
            if (column.isOptional()) {
                return null;
            }
            return Point.createValue((Schema)schema, (double)0.0, (double)0.0);
        }
        if (data instanceof PGpoint) {
            PGpoint pgPoint = (PGpoint)data;
            return Point.createValue((Schema)schema, (double)pgPoint.x, (double)pgPoint.y);
        }
        if (data instanceof String) {
            String dataString = data.toString();
            try {
                PGpoint pgPoint = new PGpoint(dataString);
                return Point.createValue((Schema)schema, (double)pgPoint.x, (double)pgPoint.y);
            }
            catch (SQLException e) {
                this.logger.warn("Error converting the string '{}' to a PGPoint type for the column '{}'", (Object)dataString, (Object)column);
            }
        }
        if (data instanceof PgProto.Point) {
            return Point.createValue((Schema)schema, (double)((PgProto.Point)data).getX(), (double)((PgProto.Point)data).getY());
        }
        return this.handleUnknownData(column, fieldDefn, data);
    }
}

