/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.connector.postgresql.Filters;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.connector.postgresql.connection.PostgresConnection;
import io.debezium.connector.postgresql.connection.ServerInfo;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.TableSchema;
import io.debezium.relational.TableSchemaBuilder;
import io.debezium.relational.Tables;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.util.AvroValidator;
import java.sql.SQLException;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class PostgresSchema {
    protected static final String PUBLIC_SCHEMA_NAME = "public";
    private static final Logger LOGGER = LoggerFactory.getLogger(PostgresSchema.class);
    private final Map<TableId, TableSchema> tableSchemaByTableId = new HashMap<TableId, TableSchema>();
    private final Filters filters;
    private final TableSchemaBuilder schemaBuilder;
    private final String schemaPrefix;
    private final Tables tables;
    private final Function<String, String> schemaNameValidator;
    private Map<String, Integer> typeInfo;

    protected PostgresSchema(PostgresConnectorConfig config) {
        this.filters = new Filters(config);
        this.tables = new Tables();
        PostgresValueConverter valueConverter = new PostgresValueConverter(config.adaptiveTimePrecision(), ZoneOffset.UTC);
        this.schemaNameValidator = arg_0 -> ((AvroValidator)AvroValidator.create((Logger)LOGGER)).validate(arg_0);
        this.schemaBuilder = new TableSchemaBuilder((ValueConverterProvider)valueConverter, this.schemaNameValidator);
        String serverName = config.serverName();
        this.schemaPrefix = serverName == null ? "" : ((serverName = serverName.trim()).endsWith(".") || serverName.isEmpty() ? serverName : serverName + ".");
    }

    protected PostgresSchema refresh(PostgresConnection connection, boolean printReplicaIdentityInfo) throws SQLException {
        if (this.typeInfo == null) {
            this.typeInfo = connection.readTypeInfo();
        }
        connection.readSchema(this.tables, null, null, this.filters.tableNameFilter(), null, true);
        if (printReplicaIdentityInfo) {
            this.tables.tableIds().forEach(tableId -> this.printReplicaIdentityInfo(connection, (TableId)tableId));
        }
        this.refreshSchemas();
        return this;
    }

    private void printReplicaIdentityInfo(PostgresConnection connection, TableId tableId) {
        try {
            ServerInfo.ReplicaIdentity replicaIdentity = connection.readReplicaIdentityInfo(tableId);
            LOGGER.info("REPLICA IDENTITY for '{}' is '{}'; {}", new Object[]{tableId, replicaIdentity.toString(), replicaIdentity.description()});
        }
        catch (SQLException e) {
            LOGGER.warn("Cannot determine REPLICA IDENTITY info for '{}'", (Object)tableId);
        }
    }

    protected void refresh(PostgresConnection connection, TableId tableId) throws SQLException {
        Tables temp = new Tables();
        Tables.TableNameFilter tableNameFilter = Tables.filterFor(Predicate.isEqual(tableId));
        connection.readSchema(temp, null, null, tableNameFilter, null, true);
        assert (temp.size() == 1);
        this.tables.overwriteTable(temp.forTable(tableId));
        this.refreshSchema(tableId);
    }

    public Filters filters() {
        return this.filters;
    }

    public Table tableFor(TableId id) {
        return this.filters.tableFilter().test(id) ? this.tables.forTable(id) : null;
    }

    protected Table tableFor(String fqn) {
        return this.tableFor(TableId.parse((String)fqn, (boolean)false));
    }

    protected String validateSchemaName(String name) {
        return this.schemaNameValidator.apply(name);
    }

    protected TableSchema schemaFor(TableId id) {
        return this.tableSchemaByTableId.get(id);
    }

    protected boolean isFilteredOut(TableId id) {
        return !this.filters.tableFilter().test(id);
    }

    protected TableSchema schemaFor(String fqn) {
        return this.schemaFor(TableId.parse((String)fqn, (boolean)false));
    }

    protected boolean isType(String localTypeName, int jdbcType) {
        return this.typeInfo != null && Integer.compare(jdbcType, this.columnTypeNameToPgOid(localTypeName)) == 0;
    }

    protected int columnTypeNameToPgOid(String localTypeName) {
        return this.typeInfo.get(localTypeName);
    }

    protected Stream<TableId> tables() {
        return this.tables.tableIds().stream();
    }

    protected void refreshSchemas() {
        this.tableSchemaByTableId.clear();
        this.tables.tableIds().forEach(this::refreshSchema);
    }

    private void refreshSchema(TableId id) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("refreshing DB schema for table '{}'", (Object)id);
        }
        Table table = this.tables.forTable(id);
        TableSchema schema = this.schemaBuilder.create(this.schemaPrefix, table, this.filters.columnFilter(), null);
        this.tableSchemaByTableId.put(id, schema);
    }

    protected static TableId parse(String table) {
        TableId tableId = TableId.parse((String)table, (boolean)false);
        if (tableId == null) {
            return null;
        }
        return tableId.schema() == null ? new TableId(tableId.catalog(), PUBLIC_SCHEMA_NAME, tableId.table()) : tableId;
    }
}

