/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import io.debezium.connector.postgresql.PostgresStreamingChangeEventSource;
import io.debezium.connector.postgresql.PostgresType;
import io.debezium.connector.postgresql.connection.ReplicationMessage;
import java.sql.SQLException;
import org.postgresql.core.BaseConnection;
import org.postgresql.jdbc.PgArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationMessageColumnValueResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReplicationMessageColumnValueResolver.class);

    public static Object resolveValue(String columnName, PostgresType type, String fullType, ReplicationMessage.ColumnValue value, PostgresStreamingChangeEventSource.PgConnectionSupplier connection, boolean includeUnknownDatatypes) {
        if (value.isNull()) {
            return null;
        }
        if (type.isArrayType()) {
            try {
                String dataString = value.asString();
                return new PgArray((BaseConnection)connection.get(), type.getOid(), dataString);
            }
            catch (SQLException e) {
                LOGGER.warn("Unexpected exception trying to process PgArray ({}) column '{}', {}", new Object[]{fullType, columnName, e});
                return null;
            }
        }
        switch (type.getName()) {
            case "boolean": 
            case "bool": {
                return value.asBoolean();
            }
            case "hstore": {
                return value.asString();
            }
            case "integer": 
            case "int": 
            case "int4": 
            case "smallint": 
            case "int2": 
            case "smallserial": 
            case "serial": 
            case "serial2": 
            case "serial4": 
            case "oid": {
                return value.asInteger();
            }
            case "bigint": 
            case "bigserial": 
            case "int8": {
                return value.asLong();
            }
            case "real": 
            case "float4": {
                return value.asFloat();
            }
            case "double precision": 
            case "float8": {
                return value.asDouble();
            }
            case "numeric": 
            case "decimal": {
                return value.asDecimal();
            }
            case "character": 
            case "char": 
            case "character varying": 
            case "varchar": 
            case "bpchar": 
            case "text": {
                return value.asString();
            }
            case "date": {
                return value.asLocalDate();
            }
            case "timestamp with time zone": 
            case "timestamptz": {
                return value.asOffsetDateTimeAtUtc();
            }
            case "timestamp": 
            case "timestamp without time zone": {
                return value.asInstant();
            }
            case "time": {
                return value.asString();
            }
            case "time without time zone": {
                return value.asLocalTime();
            }
            case "time with time zone": 
            case "timetz": {
                return value.asOffsetTimeUtc();
            }
            case "bytea": {
                return value.asByteArray();
            }
            case "box": {
                return value.asBox();
            }
            case "circle": {
                return value.asCircle();
            }
            case "interval": {
                return value.asInterval();
            }
            case "line": {
                return value.asLine();
            }
            case "lseg": {
                return value.asLseg();
            }
            case "money": {
                return value.asMoney().val;
            }
            case "path": {
                return value.asPath();
            }
            case "point": {
                return value.asPoint();
            }
            case "polygon": {
                return value.asPolygon();
            }
            case "geometry": 
            case "geography": {
                return value.asString();
            }
            case "citext": 
            case "bit": 
            case "bit varying": 
            case "varbit": 
            case "json": 
            case "jsonb": 
            case "xml": 
            case "uuid": 
            case "tsrange": 
            case "tstzrange": 
            case "daterange": 
            case "inet": 
            case "cidr": 
            case "macaddr": 
            case "macaddr8": 
            case "int4range": 
            case "numrange": 
            case "int8range": {
                return value.asString();
            }
        }
        if (includeUnknownDatatypes) {
            LOGGER.debug("processing column '{}' with unknown data type '{}' as byte array", (Object)columnName, (Object)fullType);
            return value.asString();
        }
        LOGGER.debug("Unknown column type {} for column {} \u2013\u00a0ignoring", (Object)fullType, (Object)columnName);
        return null;
    }
}

