/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql;

import io.debezium.annotation.NotThreadSafe;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.connector.AbstractSourceInfo;
import io.debezium.connector.SnapshotRecord;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.connector.postgresql.PostgresConnectorConfig;
import io.debezium.connector.postgresql.connection.ReplicationConnection;
import io.debezium.connector.postgresql.spi.OffsetState;
import io.debezium.relational.TableId;
import io.debezium.time.Conversions;
import java.lang.constant.Constable;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.connect.data.Struct;

@NotThreadSafe
public final class SourceInfo
extends AbstractSourceInfo {
    public static final String SERVER_PARTITION_KEY = "server";
    public static final String TIMESTAMP_USEC_KEY = "ts_usec";
    public static final String TXID_KEY = "txId";
    public static final String XMIN_KEY = "xmin";
    public static final String LSN_KEY = "lsn";
    public static final String LAST_SNAPSHOT_RECORD_KEY = "last_snapshot_record";
    private final String dbName;
    private final Map<String, String> sourcePartition;
    private Long lsn;
    private Long txId;
    private Long xmin;
    private Instant timestamp;
    private boolean snapshot = false;
    private Boolean lastSnapshotRecord;
    private String schemaName;
    private String tableName;
    private final SourceInfoStructMaker<SourceInfo> structMaker;

    protected SourceInfo(PostgresConnectorConfig connectorConfig) {
        super((CommonConnectorConfig)connectorConfig);
        this.dbName = connectorConfig.databaseName();
        this.sourcePartition = Collections.singletonMap(SERVER_PARTITION_KEY, connectorConfig.getLogicalName());
        this.structMaker = connectorConfig.getSourceInfoStructMaker();
    }

    protected void load(Map<String, Object> lastStoredOffset) {
        this.lsn = ((Number)lastStoredOffset.get(LSN_KEY)).longValue();
        this.txId = ((Number)lastStoredOffset.get(TXID_KEY)).longValue();
        this.xmin = (Long)lastStoredOffset.get(XMIN_KEY);
        this.timestamp = Conversions.toInstantFromMicros((long)((Long)lastStoredOffset.get(TIMESTAMP_USEC_KEY)));
        this.snapshot = lastStoredOffset.containsKey("snapshot");
        if (this.snapshot) {
            this.lastSnapshotRecord = (Boolean)lastStoredOffset.get(LAST_SNAPSHOT_RECORD_KEY);
        }
    }

    public Map<String, String> partition() {
        return this.sourcePartition;
    }

    public Map<String, ?> offset() {
        assert (this.serverName() != null && this.dbName != null);
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        if (this.timestamp != null) {
            result.put(TIMESTAMP_USEC_KEY, Long.valueOf(Conversions.toEpochMicros((Instant)this.timestamp)));
        }
        if (this.txId != null) {
            result.put(TXID_KEY, this.txId);
        }
        if (this.lsn != null) {
            result.put(LSN_KEY, this.lsn);
        }
        if (this.xmin != null) {
            result.put(XMIN_KEY, this.xmin);
        }
        if (this.snapshot) {
            result.put("snapshot", Boolean.valueOf(true));
            result.put(LAST_SNAPSHOT_RECORD_KEY, this.lastSnapshotRecord);
        }
        return result;
    }

    public OffsetState asOffsetState() {
        return new OffsetState(this.lsn, this.txId, this.xmin, this.timestamp, this.isSnapshotInEffect());
    }

    protected SourceInfo update(Long lsn, Instant commitTime, Long txId, TableId tableId, Long xmin) {
        this.lsn = lsn;
        if (commitTime != null) {
            this.timestamp = commitTime;
        }
        this.txId = txId;
        this.xmin = xmin;
        if (tableId != null && tableId.schema() != null) {
            this.schemaName = tableId.schema();
        }
        if (tableId != null && tableId.table() != null) {
            this.tableName = tableId.table();
        }
        return this;
    }

    protected SourceInfo update(Instant timestamp, TableId tableId) {
        this.timestamp = timestamp;
        if (tableId != null && tableId.schema() != null) {
            this.schemaName = tableId.schema();
        }
        if (tableId != null && tableId.table() != null) {
            this.tableName = tableId.table();
        }
        return this;
    }

    protected SourceInfo markLastSnapshotRecord() {
        this.lastSnapshotRecord = true;
        return this;
    }

    protected Struct source() {
        return this.structMaker.struct((AbstractSourceInfo)this);
    }

    public boolean isSnapshotInEffect() {
        return this.snapshot && (this.lastSnapshotRecord == null || this.lastSnapshotRecord == false);
    }

    protected void startSnapshot() {
        this.snapshot = true;
        this.lastSnapshotRecord = false;
    }

    protected void completeSnapshot() {
        this.snapshot = false;
    }

    public Long lsn() {
        return this.lsn;
    }

    public Long xmin() {
        return this.xmin;
    }

    protected String database() {
        return this.dbName;
    }

    String schemaName() {
        return this.schemaName;
    }

    String tableName() {
        return this.tableName;
    }

    protected Instant timestamp() {
        return this.timestamp;
    }

    protected SnapshotRecord snapshot() {
        if (this.snapshot) {
            if (this.lastSnapshotRecord.booleanValue()) {
                return SnapshotRecord.LAST;
            }
            return SnapshotRecord.TRUE;
        }
        return SnapshotRecord.FALSE;
    }

    public boolean hasLastKnownPosition() {
        return this.lsn != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("source_info[");
        sb.append("server='").append(this.serverName()).append('\'');
        sb.append("db='").append(this.dbName).append('\'');
        if (this.lsn != null) {
            sb.append(", lsn=").append(ReplicationConnection.format(this.lsn));
        }
        if (this.txId != null) {
            sb.append(", txId=").append(this.txId);
        }
        if (this.xmin != null) {
            sb.append(", xmin=").append(this.xmin);
        }
        if (this.timestamp != null) {
            sb.append(", timestamp=").append(this.timestamp);
        }
        boolean snapshotInEffect = this.isSnapshotInEffect();
        sb.append(", snapshot=").append(snapshotInEffect);
        if (snapshotInEffect) {
            sb.append(", last_snapshot_record=").append(this.lastSnapshotRecord);
        }
        if (this.schemaName != null) {
            sb.append(", schema=").append(this.schemaName);
        }
        if (this.tableName != null) {
            sb.append(", table=").append(this.tableName);
        }
        sb.append(']');
        return sb.toString();
    }
}

