/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink.eventhandler.relational;

import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.WriteModel;
import io.debezium.connector.mongodb.sink.converters.SinkDocument;
import io.debezium.connector.mongodb.sink.eventhandler.EventOperation;
import io.debezium.connector.mongodb.sink.eventhandler.relational.RelationalEventHandler;
import io.debezium.data.Envelope;
import io.debezium.sink.naming.ColumnNamingStrategy;
import org.apache.kafka.connect.errors.DataException;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;

public class RelationalDeleteEvent
implements EventOperation {
    @Override
    public WriteModel<BsonDocument> perform(SinkDocument doc, ColumnNamingStrategy columnNamingStrategy) {
        BsonDocument keyDoc = doc.getKeyDoc().orElseThrow(() -> new DataException("Key document must not be missing for delete operation"));
        BsonDocument valueDoc = doc.getValueDoc().orElseThrow(() -> new DataException("Value document must not be missing for delete operation"));
        try {
            BsonDocument filterDoc = RelationalEventHandler.generateFilterDoc(keyDoc, valueDoc, Envelope.Operation.DELETE, columnNamingStrategy);
            return new DeleteOneModel((Bson)filterDoc);
        }
        catch (Exception exc) {
            throw new DataException((Throwable)exc);
        }
    }
}

