/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb.sink;

import io.debezium.bindings.kafka.KafkaDebeziumSinkRecord;
import io.debezium.connector.mongodb.sink.MongoDbSinkConnectorConfig;
import io.debezium.connector.mongodb.sink.MongoProcessedSinkRecordData;
import io.debezium.dlq.ErrorReporter;
import io.debezium.sink.DebeziumSinkRecord;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MongoSinkRecordProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoSinkRecordProcessor.class);

    private MongoSinkRecordProcessor() {
    }

    static List<List<MongoProcessedSinkRecordData>> orderedGroupByTopicAndNamespace(Collection<SinkRecord> records, MongoDbSinkConnectorConfig sinkConfig, ErrorReporter errorReporter) {
        LOGGER.debug("Number of sink records to process: {}", (Object)records.size());
        ArrayList<List<MongoProcessedSinkRecordData>> orderedProcessedSinkRecordData = new ArrayList<List<MongoProcessedSinkRecordData>>();
        ArrayList<MongoProcessedSinkRecordData> groupedBatch = new ArrayList<MongoProcessedSinkRecordData>();
        MongoProcessedSinkRecordData previous = null;
        for (SinkRecord kafkaSinkRecord : records) {
            int maxBatchSize;
            KafkaDebeziumSinkRecord record = new KafkaDebeziumSinkRecord(kafkaSinkRecord, sinkConfig.cloudEventsSchemaNamePattern());
            MongoProcessedSinkRecordData processedData = new MongoProcessedSinkRecordData((DebeziumSinkRecord)record, sinkConfig);
            if (processedData.getException() != null) {
                errorReporter.report(processedData.getSinkRecord(), processedData.getException());
                continue;
            }
            if (processedData.getNamespace() == null || processedData.getWriteModel() == null) continue;
            if (previous == null) {
                previous = processedData;
            }
            if ((maxBatchSize = processedData.getConfig().getBatchSize()) > 0 && groupedBatch.size() == maxBatchSize || !previous.getSinkRecord().topicName().equals(processedData.getSinkRecord().topicName()) || !previous.getNamespace().equals((Object)processedData.getNamespace())) {
                orderedProcessedSinkRecordData.add(groupedBatch);
                groupedBatch = new ArrayList();
            }
            previous = processedData;
            groupedBatch.add(processedData);
        }
        if (!groupedBatch.isEmpty()) {
            orderedProcessedSinkRecordData.add(groupedBatch);
        }
        return orderedProcessedSinkRecordData;
    }
}

