/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.DebeziumException;
import io.debezium.annotation.ThreadSafe;
import io.debezium.bean.StandardBeanNames;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.base.ChangeEventQueueMetrics;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.connector.common.CdcSourceTaskContext;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.Module;
import io.debezium.connector.mongodb.MongoDbChangeEventSourceFactory;
import io.debezium.connector.mongodb.MongoDbConnector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.connector.mongodb.MongoDbErrorHandler;
import io.debezium.connector.mongodb.MongoDbEventMetadataProvider;
import io.debezium.connector.mongodb.MongoDbOffsetContext;
import io.debezium.connector.mongodb.MongoDbPartition;
import io.debezium.connector.mongodb.MongoDbSchema;
import io.debezium.connector.mongodb.MongoDbTaskContext;
import io.debezium.connector.mongodb.connection.MongoDbConnection;
import io.debezium.connector.mongodb.connection.MongoDbConnectionContext;
import io.debezium.connector.mongodb.metrics.MongoDbChangeEventSourceMetricsFactory;
import io.debezium.document.DocumentReader;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.metrics.spi.ChangeEventSourceMetricsFactory;
import io.debezium.pipeline.notification.NotificationService;
import io.debezium.pipeline.signal.SignalProcessor;
import io.debezium.pipeline.source.spi.ChangeEventSourceFactory;
import io.debezium.pipeline.source.spi.EventMetadataProvider;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.SchemaFactory;
import io.debezium.schema.SchemaNameAdjuster;
import io.debezium.snapshot.SnapshotterService;
import io.debezium.spi.snapshot.Snapshotter;
import io.debezium.util.Clock;
import io.debezium.util.LoggingContext;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MongoDbConnectorTask
extends BaseSourceTask<MongoDbPartition, MongoDbOffsetContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDbConnectorTask.class);
    private static final String CONTEXT_NAME = "mongodb-connector-task";
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile String taskName;
    private volatile MongoDbTaskContext taskContext;
    private volatile MongoDbConnectionContext connectionContext;
    private volatile ErrorHandler errorHandler;
    private volatile MongoDbSchema schema;

    public String version() {
        return Module.version();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangeEventSourceCoordinator<MongoDbPartition, MongoDbOffsetContext> start(Configuration config) {
        MongoDbConnectorConfig connectorConfig = new MongoDbConnectorConfig(config);
        SchemaNameAdjuster schemaNameAdjuster = connectorConfig.schemaNameAdjuster();
        this.taskName = "task" + config.getInteger(MongoDbConnectorConfig.TASK_ID);
        this.taskContext = new MongoDbTaskContext(config);
        this.connectionContext = new MongoDbConnectionContext(config);
        Schema structSchema = connectorConfig.getSourceInfoStructMaker().schema();
        this.schema = new MongoDbSchema(this.taskContext.getFilters(), this.taskContext.getTopicNamingStrategy(), structSchema, schemaNameAdjuster);
        Offsets<MongoDbPartition, MongoDbOffsetContext> previousOffsets = this.getPreviousOffsets(connectorConfig);
        Clock clock = Clock.system();
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext(this.taskName);
        try {
            this.queue = new ChangeEventQueue.Builder().pollInterval(connectorConfig.getPollInterval()).maxBatchSize(connectorConfig.getMaxBatchSize()).maxQueueSize(connectorConfig.getMaxQueueSize()).maxQueueSizeInBytes(connectorConfig.getMaxQueueSizeInBytes()).loggingContextSupplier(() -> this.taskContext.configureLoggingContext(CONTEXT_NAME)).build();
            this.errorHandler = new MongoDbErrorHandler(connectorConfig, this.queue, this.errorHandler);
            MongoDbEventMetadataProvider metadataProvider = new MongoDbEventMetadataProvider();
            SignalProcessor signalProcessor = new SignalProcessor(MongoDbConnector.class, (CommonConnectorConfig)connectorConfig, Map.of(), this.getAvailableSignalChannels(), DocumentReader.defaultReader(), previousOffsets);
            connectorConfig.getBeanRegistry().add("ConnectorConfig", (Object)connectorConfig);
            connectorConfig.getBeanRegistry().add("Schema", (Object)this.schema);
            connectorConfig.getBeanRegistry().add(StandardBeanNames.OFFSETS, previousOffsets);
            this.registerServiceProviders(connectorConfig.getServiceRegistry());
            SnapshotterService snapshotterService = (SnapshotterService)connectorConfig.getServiceRegistry().tryGetService(SnapshotterService.class);
            EventDispatcher dispatcher = new EventDispatcher((CommonConnectorConfig)connectorConfig, this.taskContext.getTopicNamingStrategy(), (DatabaseSchema)this.schema, this.queue, this.taskContext.getFilters().collectionFilter()::test, DataChangeEvent::new, (EventMetadataProvider)metadataProvider, schemaNameAdjuster, signalProcessor);
            this.validate(connectorConfig, this.taskContext.getConnection((EventDispatcher<MongoDbPartition, CollectionId>)dispatcher, (MongoDbPartition)previousOffsets.getTheOnlyPartition()), previousOffsets, snapshotterService.getSnapshotter());
            NotificationService notificationService = new NotificationService(this.getNotificationChannels(), (CommonConnectorConfig)connectorConfig, SchemaFactory.get(), arg_0 -> ((EventDispatcher)dispatcher).enqueueNotification(arg_0));
            MongoDbChangeEventSourceMetricsFactory metricsFactory = new MongoDbChangeEventSourceMetricsFactory();
            ChangeEventSourceCoordinator coordinator = new ChangeEventSourceCoordinator(previousOffsets, this.errorHandler, MongoDbConnector.class, (CommonConnectorConfig)connectorConfig, (ChangeEventSourceFactory)new MongoDbChangeEventSourceFactory(connectorConfig, this.errorHandler, (EventDispatcher<MongoDbPartition, CollectionId>)dispatcher, clock, this.taskContext, this.schema, metricsFactory.getStreamingMetrics(this.taskContext, (ChangeEventQueueMetrics)this.queue, (EventMetadataProvider)metadataProvider), snapshotterService), (ChangeEventSourceMetricsFactory)metricsFactory, dispatcher, (DatabaseSchema)this.schema, signalProcessor, notificationService, snapshotterService);
            coordinator.start((CdcSourceTaskContext)this.taskContext, this.queue, (EventMetadataProvider)metadataProvider);
            ChangeEventSourceCoordinator changeEventSourceCoordinator = coordinator;
            return changeEventSourceCoordinator;
        }
        finally {
            previousLogContext.restore();
        }
    }

    private Offsets<MongoDbPartition, MongoDbOffsetContext> getPreviousOffsets(MongoDbConnectorConfig connectorConfig) {
        MongoDbPartition.Provider partitionProvider = new MongoDbPartition.Provider(connectorConfig);
        MongoDbOffsetContext.Loader offsetLoader = new MongoDbOffsetContext.Loader(connectorConfig);
        Offsets offsets = this.getPreviousOffsets(partitionProvider, offsetLoader);
        if (offsets.getTheOnlyOffset() != null) {
            return offsets;
        }
        LOGGER.info("Previous valid offset not found, checking compatible offsets from older versions");
        String name = this.connectionContext.getRequiredReplicaSetName().orElse("cluster");
        MongoDbOffsetContext compatibleOffset = (MongoDbOffsetContext)this.getPreviousOffsets(new MongoDbPartition.Provider(connectorConfig, Set.of(name)), new MongoDbOffsetContext.Loader(connectorConfig)).getTheOnlyOffset();
        if (compatibleOffset != null) {
            LOGGER.warn("Found compatible offset from previous version");
            offsets.getOffsets().put((MongoDbPartition)offsets.getTheOnlyPartition(), compatibleOffset);
            return offsets;
        }
        LOGGER.info("Compatible offset not found, checking shard specific offsets from replica_set connection mode.");
        Set<String> shardNames = this.connectionContext.getShardNames();
        Map shardOffsets = this.getPreviousOffsets(new MongoDbPartition.Provider(connectorConfig, shardNames), new MongoDbOffsetContext.Loader(connectorConfig)).getOffsets();
        if (shardOffsets.values().stream().allMatch(Objects::isNull)) {
            LOGGER.info("No shard specific offsets found");
            return offsets;
        }
        LOGGER.warn("Found at least one shard specific offset from previous version");
        if (shardOffsets.values().stream().anyMatch(Objects::isNull)) {
            LOGGER.warn("At least one shard is missing previously recorded offset, so empty offset will be used");
            return offsets;
        }
        if (!connectorConfig.isOffsetInvalidationAllowed()) {
            LOGGER.warn("Offset invalidation is not allowed");
            throw new DebeziumException("Offsets from previous version are invalid, either manually delete them or set '" + MongoDbConnectorConfig.ALLOW_OFFSET_INVALIDATION.name() + "=true' to allow streaming to resume from the oldest shard specific offset");
        }
        LOGGER.warn("Offset invalidation is allowed");
        LOGGER.warn("The oldest shard specific offset will be used");
        Optional<MongoDbOffsetContext> oldestOffset = shardOffsets.values().stream().filter(offset -> offset.lastTimestampOrTokenTime() != null).min(Comparator.comparing(MongoDbOffsetContext::lastTimestampOrTokenTime));
        oldestOffset.ifPresent(offset -> offsets.getOffsets().put((MongoDbPartition)offsets.getTheOnlyPartition(), offset));
        return offsets;
    }

    public List<SourceRecord> doPoll() throws InterruptedException {
        List records = this.queue.poll();
        return records.stream().map(DataChangeEvent::getRecord).collect(Collectors.toList());
    }

    public void doStop() {
        LoggingContext.PreviousContext previousLogContext = this.taskContext.configureLoggingContext(this.taskName);
        try {
            if (this.schema != null) {
                this.schema.close();
            }
        }
        finally {
            previousLogContext.restore();
        }
    }

    protected Iterable<Field> getAllConfigurationFields() {
        return MongoDbConnectorConfig.ALL_FIELDS;
    }

    protected Configuration withMaskedSensitiveOptions(Configuration config) {
        return super.withMaskedSensitiveOptions(config).withMasked(MongoDbConnectorConfig.CONNECTION_STRING.name());
    }

    private void validate(MongoDbConnectorConfig connectorConfig, MongoDbConnection mongoDbConnection, Offsets<MongoDbPartition, MongoDbOffsetContext> previousOffsets, Snapshotter snapshotter) {
        for (Map.Entry previousOffset : previousOffsets) {
            boolean logPositionAvailable;
            MongoDbOffsetContext offset = (MongoDbOffsetContext)((Object)previousOffset.getValue());
            if (offset == null) {
                LOGGER.info("Connector started for the first time.");
                LOGGER.info("No previous offset has been found");
                return;
            }
            if (offset.isSnapshotRunning()) {
                if (!snapshotter.shouldSnapshotData(true, true)) {
                    throw new DebeziumException("The connector previously stopped while taking a snapshot, but now the connector is configured to never allow snapshots. Reconfigure the connector to use snapshots initially or when needed.");
                }
                LOGGER.info("The previous snapshot was incomplete, so restarting the snapshot");
                return;
            }
            if (!connectorConfig.isLogPositionCheckEnabled() || (logPositionAvailable = mongoDbConnection.validateLogPosition(offset, this.taskContext))) continue;
            LOGGER.warn("Last recorded offset is no longer available on the server.");
            if (snapshotter.shouldSnapshotOnDataError()) {
                LOGGER.info("The last recorded offset is no longer available but we are in {} snapshot mode. Attempting to snapshot data to fill the gap.", (Object)snapshotter.name());
                previousOffsets.resetOffset((Partition)((MongoDbPartition)previousOffsets.getTheOnlyPartition()));
                return;
            }
            LOGGER.warn("The connector is trying to read change stream starting at " + String.valueOf((Object)offset) + ", but this is no longer available on the server. Reconfigure the connector to use a snapshot when needed if you want to recover. If not the connector will streaming from the last available position in the log");
        }
    }
}

