/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import com.mongodb.BasicDBObject;
import java.util.function.Function;
import org.bson.BsonDocument;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;

class JsonSerialization {
    private static final String ID_FIELD_NAME = "_id";
    public static final JsonWriterSettings COMPACT_JSON_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.STRICT).indent(true).indentCharacters("").newLineCharacters("").build();
    private static final JsonWriterSettings SIMPLE_JSON_SETTINGS = JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).indent(true).indentCharacters("").newLineCharacters("").build();
    private final Transformer transformer = doc -> doc.toJson(COMPACT_JSON_SETTINGS);

    JsonSerialization() {
    }

    public String getDocumentId(BsonDocument document) {
        if (document == null) {
            return null;
        }
        String keyValue = new BasicDBObject("_", (Object)document.get((Object)ID_FIELD_NAME)).toJson(SIMPLE_JSON_SETTINGS);
        int start = 6;
        int end = keyValue.length() - 1;
        if (end <= 6) {
            throw new IllegalStateException("Serialized JSON object '" + keyValue + "' is not in expected format");
        }
        return keyValue.substring(6, end);
    }

    public String getDocumentValue(BsonDocument document) {
        return (String)this.transformer.apply(document);
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    @FunctionalInterface
    public static interface Transformer
    extends Function<BsonDocument, String> {
    }
}

