/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.mongodb.ChangeStreamPipeline;
import io.debezium.connector.mongodb.CollectionId;
import io.debezium.connector.mongodb.FieldSelector;
import io.debezium.connector.mongodb.MongoDbConnectorConfig;
import io.debezium.function.Predicates;
import io.debezium.util.Collect;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Filters {
    private final FilterConfig config;
    private final Predicate<String> databaseFilter;
    private final Predicate<CollectionId> collectionFilter;
    private final FieldSelector fieldSelector;

    public Filters(Configuration configuration) {
        this.config = new FilterConfig(configuration);
        this.databaseFilter = this.createDatabaseFilter();
        this.collectionFilter = this.createCollectionFilter();
        this.fieldSelector = this.createFieldSelector();
    }

    private Predicate<String> createDatabaseFilter() {
        Optional<String> dbIncludeList = this.config.getDbIncludeList();
        Optional<String> dbExcludeList = this.config.getDbExcludeList();
        return Optional.empty().or(() -> dbIncludeList.map(value -> this.includes((String)value, s -> s))).or(() -> dbExcludeList.map(value -> this.excludes((String)value, s -> s))).orElse(db -> true);
    }

    private Predicate<CollectionId> createCollectionFilter() {
        Optional<String> collectionIncludeList = this.config.getCollectionIncludeList();
        Optional<String> collectionExcludeList = this.config.getCollectionExcludeList();
        Predicate<CollectionId> collectionFilter = Optional.empty().or(() -> collectionIncludeList.map(list -> this.includes((String)list, CollectionId::namespace))).or(() -> collectionExcludeList.map(list -> this.excludes((String)list, CollectionId::namespace))).orElse(id -> true).and(this::isNotBuiltIn);
        Optional<Predicate> signalCollectionFilter = this.config.getSignalDataCollection().map(id -> CollectionId.parse("UNUSED", id)).filter(id -> !collectionFilter.test((CollectionId)id)).map(id -> Predicates.includes((String)id.namespace(), CollectionId::namespace));
        return signalCollectionFilter.map(collectionFilter::or).orElse(collectionFilter);
    }

    private FieldSelector createFieldSelector() {
        return FieldSelector.builder().excludeFields(this.config.getFieldExcludeList()).renameFields(this.config.getFieldRenames()).build();
    }

    public Predicate<String> databaseFilter() {
        return this.databaseFilter;
    }

    public Predicate<CollectionId> collectionFilter() {
        return this.collectionFilter;
    }

    public FieldSelector.FieldFilter fieldFilterFor(CollectionId id) {
        return this.fieldSelector.fieldFilterFor(id);
    }

    private boolean isNotBuiltIn(CollectionId id) {
        return !this.config.getBuiltInDbNames().contains(id.dbName());
    }

    private <T> Predicate<T> includes(String literalsOrPatterns, Function<T, String> conversion) {
        if (this.config.isLiteralsMatchMode()) {
            return Predicates.includesLiterals((String)literalsOrPatterns, conversion, (boolean)true);
        }
        return Predicates.includes((String)literalsOrPatterns, conversion);
    }

    private <T> Predicate<T> excludes(String literalsOrPatterns, Function<T, String> conversion) {
        if (this.config.isLiteralsMatchMode()) {
            return Predicates.excludesLiterals((String)literalsOrPatterns, conversion, (boolean)true);
        }
        return Predicates.excludes((String)literalsOrPatterns, conversion);
    }

    public FilterConfig getConfig() {
        return this.config;
    }

    public static class FilterConfig {
        private static final Set<String> BUILT_IN_DB_NAMES = Collect.unmodifiableSet((Object[])new String[]{"local", "admin", "config"});
        private final String dbIncludeList;
        private final String dbExcludeList;
        private final String collectionIncludeList;
        private final String collectionExcludeList;
        private final String fieldRenames;
        private final String fieldExcludeList;
        private final String signalDataCollection;
        private final ChangeStreamPipeline userPipeline;
        private final MongoDbConnectorConfig.FiltersMatchMode filtersMatchMode;
        private final boolean literalMatchMode;

        public FilterConfig(Configuration config) {
            MongoDbConnectorConfig connectorConfig = new MongoDbConnectorConfig(config);
            this.dbIncludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.DATABASE_INCLUDE_LIST);
            this.dbExcludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.DATABASE_EXCLUDE_LIST);
            this.collectionIncludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.COLLECTION_INCLUDE_LIST);
            this.collectionExcludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.COLLECTION_EXCLUDE_LIST);
            this.fieldRenames = FilterConfig.resolveString(config, MongoDbConnectorConfig.FIELD_RENAMES);
            this.fieldExcludeList = FilterConfig.resolveString(config, MongoDbConnectorConfig.FIELD_EXCLUDE_LIST);
            this.signalDataCollection = FilterConfig.resolveString(config, MongoDbConnectorConfig.SIGNAL_DATA_COLLECTION);
            this.userPipeline = FilterConfig.resolveChangeStreamPipeline(config, MongoDbConnectorConfig.CURSOR_PIPELINE);
            this.filtersMatchMode = connectorConfig.getFiltersMatchMode();
            this.literalMatchMode = MongoDbConnectorConfig.FiltersMatchMode.LITERAL.equals((Object)this.filtersMatchMode);
        }

        public Optional<String> getDbIncludeList() {
            return Optional.ofNullable(this.dbIncludeList);
        }

        public Optional<String> getDbExcludeList() {
            return Optional.ofNullable(this.dbExcludeList);
        }

        public Optional<String> getCollectionIncludeList() {
            return Optional.ofNullable(this.collectionIncludeList);
        }

        public Optional<String> getCollectionExcludeList() {
            return Optional.ofNullable(this.collectionExcludeList);
        }

        public String getFieldRenames() {
            return this.fieldRenames;
        }

        public String getFieldExcludeList() {
            return this.fieldExcludeList;
        }

        public Optional<String> getSignalDataCollection() {
            return Optional.ofNullable(this.signalDataCollection);
        }

        public Set<String> getBuiltInDbNames() {
            return BUILT_IN_DB_NAMES;
        }

        public ChangeStreamPipeline getUserPipeline() {
            return this.userPipeline;
        }

        public MongoDbConnectorConfig.FiltersMatchMode getFiltersMatchMode() {
            return this.filtersMatchMode;
        }

        public boolean isLiteralsMatchMode() {
            return this.literalMatchMode;
        }

        private static String resolveString(Configuration config, Field key) {
            return FilterConfig.normalize(config.getString(key));
        }

        private static ChangeStreamPipeline resolveChangeStreamPipeline(Configuration config, Field field) {
            String text = config.getString(field);
            return new ChangeStreamPipeline(text);
        }

        private static String normalize(String text) {
            if (text == null) {
                return null;
            }
            if ((text = text.trim()).isEmpty()) {
                return null;
            }
            return text;
        }
    }
}

