/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.mongodb;

import io.debezium.annotation.Immutable;
import io.debezium.connector.mongodb.connection.ReplicaSet;
import io.debezium.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.apache.kafka.connect.util.ConnectorUtils;

@Immutable
public class ReplicaSets {
    public static final String SEPARATOR = "|";
    private final List<ReplicaSet> replicaSets = new ArrayList<ReplicaSet>();

    public static ReplicaSets empty() {
        return new ReplicaSets(null);
    }

    public static ReplicaSets of(ReplicaSet ... replicaSets) {
        return new ReplicaSets(Arrays.asList(replicaSets));
    }

    public ReplicaSets(Collection<ReplicaSet> rsSpecs) {
        if (rsSpecs != null) {
            this.replicaSets.addAll(rsSpecs);
        }
        Collections.sort(this.replicaSets);
    }

    public int size() {
        return this.replicaSets.size();
    }

    public void onEachReplicaSet(Consumer<ReplicaSet> function) {
        this.replicaSets.forEach(function);
    }

    public void subdivide(int maxSubdivisionCount, Consumer<ReplicaSets> subdivisionConsumer) {
        int numGroups = Math.min(this.size(), maxSubdivisionCount);
        ConnectorUtils.groupPartitions(this.all(), (int)numGroups).stream().map(ReplicaSets::new).forEach(subdivisionConsumer);
    }

    public List<ReplicaSet> all() {
        return new ArrayList<ReplicaSet>(this.replicaSets);
    }

    public ReplicaSet getSnapshotReplicaSet() {
        return this.all().get(0);
    }

    public boolean haveChangedSince(ReplicaSets priorState) {
        return !this.replicaSets.equals(priorState.replicaSets);
    }

    public int hashCode() {
        return this.replicaSets.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReplicaSets) {
            ReplicaSets that = (ReplicaSets)obj;
            return this.replicaSets.equals(that.replicaSets);
        }
        return false;
    }

    public String toString() {
        return Strings.join((CharSequence)";", this.all());
    }
}

